/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.ArrayArray;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.ScalarField;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class FieldDataWrapper {
    private final FieldData fieldData;
    private List<?> cacheData = null;

    public FieldDataWrapper(@NonNull FieldData fieldData) {
        if (fieldData == null) {
            throw new NullPointerException("fieldData is marked non-null but is null");
        }
        this.fieldData = fieldData;
    }

    public boolean isVectorField() {
        return this.fieldData.getType() == DataType.FloatVector || this.fieldData.getType() == DataType.BinaryVector;
    }

    public boolean isJsonField() {
        return this.fieldData.getType() == DataType.JSON;
    }

    public boolean isDynamicField() {
        return this.fieldData.getType() == DataType.JSON && this.fieldData.getIsDynamic();
    }

    public int getDim() throws IllegalResponseException {
        if (!this.isVectorField()) {
            throw new IllegalResponseException("Not a vector field");
        }
        return (int)this.fieldData.getVectors().getDim();
    }

    public long getRowCount() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                return data.size() / dim;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() * 8 % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                return data.size() * 8 / dim;
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataCount();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataCount();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataCount();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataCount();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataCount();
            }
            case VarChar: 
            case String: {
                return this.fieldData.getScalars().getStringData().getDataCount();
            }
            case JSON: {
                return this.fieldData.getScalars().getJsonData().getDataCount();
            }
            case Array: {
                return this.fieldData.getScalars().getArrayData().getDataCount();
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    public List<?> getFieldData() throws IllegalResponseException {
        if (this.cacheData != null) {
            return this.cacheData;
        }
        this.cacheData = this.getFieldDataInternal();
        return this.cacheData;
    }

    private List<?> getFieldDataInternal() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                ArrayList<List<Float>> packData = new ArrayList<List<Float>>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    packData.add(data.subList(i * dim, (i + 1) * dim));
                }
                return packData;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() * 8 % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                ArrayList<ByteBuffer> packData = new ArrayList<ByteBuffer>();
                int bytePerVec = dim / 8;
                int count = data.size() / bytePerVec;
                for (int i = 0; i < count; ++i) {
                    ByteBuffer bf = ByteBuffer.allocate(bytePerVec);
                    bf.put(data.substring(i * bytePerVec, (i + 1) * bytePerVec).toByteArray());
                    packData.add(bf);
                }
                return packData;
            }
            case Array: {
                ArrayList array = new ArrayList();
                ArrayArray arrArray = this.fieldData.getScalars().getArrayData();
                for (int i = 0; i < arrArray.getDataCount(); ++i) {
                    ScalarField scalar = arrArray.getData(i);
                    array.add(this.getScalarData(arrArray.getElementType(), scalar));
                }
                return array;
            }
            case Int64: 
            case Int32: 
            case Int16: 
            case Int8: 
            case Bool: 
            case Float: 
            case Double: 
            case VarChar: 
            case String: 
            case JSON: {
                return this.getScalarData(dt, this.fieldData.getScalars());
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    private List<?> getScalarData(DataType dt, ScalarField scalar) {
        switch (dt) {
            case Int64: {
                return scalar.getLongData().getDataList();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return scalar.getIntData().getDataList();
            }
            case Bool: {
                return scalar.getBoolData().getDataList();
            }
            case Float: {
                return scalar.getFloatData().getDataList();
            }
            case Double: {
                return scalar.getDoubleData().getDataList();
            }
            case VarChar: 
            case String: {
                ProtocolStringList protoStrList = scalar.getStringData().getDataList();
                return protoStrList.subList(0, protoStrList.size());
            }
            case JSON: {
                List<ByteString> dataList = scalar.getJsonData().getDataList();
                return dataList.stream().map(ByteString::toByteArray).collect(Collectors.toList());
            }
        }
        return new ArrayList();
    }

    public Integer getAsInt(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Integer.valueOf(Integer.parseInt(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public String getAsString(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            JsonElement jsonElement = this.parseObjectData(index);
            if (jsonElement instanceof JsonObject) {
                return ((JsonObject)jsonElement).get(paramName).getAsString();
            }
            throw new IllegalResponseException("The JSON element is not a dict");
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Boolean getAsBool(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Boolean.valueOf(Boolean.parseBoolean(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Double getAsDouble(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Double.valueOf(Double.parseDouble(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Object get(int index, String paramName) throws IllegalResponseException {
        if (!this.isJsonField()) {
            throw new IllegalResponseException("Only JSON type support this operation");
        }
        JsonElement jsonElement = this.parseObjectData(index);
        if (!(jsonElement instanceof JsonObject)) {
            throw new IllegalResponseException("The JSON element is not a dict");
        }
        JsonElement element = ((JsonObject)jsonElement).get(paramName);
        return FieldDataWrapper.ValueOfJSONElement(element);
    }

    public Object valueByIdx(int index) throws ParamException {
        if (index < 0 || index >= this.getFieldData().size()) {
            throw new ParamException("index out of range");
        }
        return this.getFieldData().get(index);
    }

    private JsonElement parseObjectData(int index) {
        Object object = this.valueByIdx(index);
        return FieldDataWrapper.ParseJSONObject(object);
    }

    public static JsonElement ParseJSONObject(Object object) {
        if (object instanceof String) {
            return JsonParser.parseString((String)((String)object));
        }
        if (object instanceof byte[]) {
            return JsonParser.parseString((String)new String((byte[])object));
        }
        throw new IllegalResponseException("Illegal type value for JSON parser");
    }

    public static Object ValueOfJSONElement(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                if (primitive.getAsBigDecimal().scale() == 0) {
                    return primitive.getAsLong();
                }
                return primitive.getAsDouble();
            }
        }
        return element;
    }
}

