/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DslType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.SearchRequest;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VectorUtils {
    private static final Gson GSON_INSTANCE = new Gson();

    public QueryRequest ConvertToGrpcQueryRequest(QueryReq request) {
        long limit;
        QueryRequest.Builder builder = QueryRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).addAllOutputFields(request.getOutputFields()).setExpr(request.getFilter());
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        long offset = request.getOffset();
        if (offset > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(offset)).build());
        }
        if ((limit = request.getLimit()) > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("limit").setValue(String.valueOf(limit)).build());
        }
        return builder.build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevel consistencyLevel, long guaranteeTimestamp, Long gracefulTime) {
        if (consistencyLevel == null) {
            return 1L;
        }
        switch (consistencyLevel) {
            case STRONG: {
                guaranteeTimestamp = 0L;
                break;
            }
            case BOUNDED: {
                guaranteeTimestamp = new Date().getTime() - gracefulTime;
                break;
            }
            case EVENTUALLY: {
                guaranteeTimestamp = 1L;
            }
        }
        return guaranteeTimestamp;
    }

    public SearchRequest ConvertToGrpcSearchRequest(SearchReq request) {
        List<BaseVector> vectors;
        SearchRequest.Builder builder = SearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (!request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if ((vectors = request.getData()).isEmpty()) {
            throw new ParamException("Target vectors list of search request is empty.");
        }
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        ArrayList<Object> data = new ArrayList<Object>();
        for (BaseVector vector : vectors) {
            if (vector.getPlaceholderType() != plType) {
                throw new ParamException("Different types of target vectors in a search request is not allowed.");
            }
            data.add(vector.getData());
        }
        ByteString byteStr = ParamUtils.convertPlaceholder(data, plType);
        builder.setPlaceholderGroup(byteStr);
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(request.getAnnsField()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(request.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(request.getRoundDecimal())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(request.isIgnoreGrowing())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(request.getOffset())).build());
        if (null != request.getSearchParams()) {
            try {
                String searchParams = GSON_INSTANCE.toJson(request.getSearchParams());
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(searchParams).build());
            }
            catch (IllegalArgumentException e) {
                throw new ParamException(e.getMessage() + e.getCause().getMessage());
            }
        }
        if (!request.getOutputFields().isEmpty()) {
            request.getOutputFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            builder.setDsl(request.getFilter());
        }
        long guaranteeTimestamp = VectorUtils.getGuaranteeTimestamp(request.getConsistencyLevel(), request.getGuaranteeTimestamp(), request.getGracefulTime());
        builder.setGuaranteeTimestamp(guaranteeTimestamp);
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public String getExprById(String primaryFieldName, List<?> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append(primaryFieldName).append(" in [");
        for (Object id : ids) {
            if (id instanceof String) {
                sb.append("\"").append(id.toString()).append("\",");
                continue;
            }
            sb.append(id.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

