/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import io.modelcontextprotocol.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class StdioServerTransport
implements ServerMcpTransport {
    private static final Logger logger = LoggerFactory.getLogger(StdioServerTransport.class);
    private final Sinks.Many<McpSchema.JSONRPCMessage> inboundSink;
    private final Sinks.Many<McpSchema.JSONRPCMessage> outboundSink;
    private ObjectMapper objectMapper;
    private Scheduler inboundScheduler;
    private Scheduler outboundScheduler;
    private volatile boolean isClosing = false;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Sinks.One<Void> inboundReady = Sinks.one();
    private final Sinks.One<Void> outboundReady = Sinks.one();

    public StdioServerTransport() {
        this(new ObjectMapper());
    }

    public StdioServerTransport(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "The ObjectMapper can not be null");
        this.inboundSink = Sinks.many().unicast().onBackpressureBuffer();
        this.outboundSink = Sinks.many().unicast().onBackpressureBuffer();
        this.objectMapper = objectMapper;
        this.inputStream = System.in;
        this.outputStream = System.out;
        this.inboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"inbound");
        this.outboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"outbound");
    }

    @Override
    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return Mono.fromRunnable(() -> {
            this.handleIncomingMessages(handler);
            this.startInboundProcessing();
            this.startOutboundProcessing();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private void handleIncomingMessages(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> inboundMessageHandler) {
        this.inboundSink.asFlux().flatMap(message -> Mono.just((Object)message).transform(inboundMessageHandler).contextWrite(ctx -> ctx.put((Object)"observation", (Object)"myObservation"))).doOnTerminate(() -> {
            this.outboundSink.tryEmitComplete();
            this.inboundScheduler.dispose();
        }).subscribe();
    }

    @Override
    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        return Mono.zip((Mono)this.inboundReady.asMono(), (Mono)this.outboundReady.asMono()).then(Mono.defer(() -> {
            if (this.outboundSink.tryEmitNext((Object)message).isSuccess()) {
                return Mono.empty();
            }
            return Mono.error((Throwable)new RuntimeException("Failed to enqueue message"));
        }));
    }

    private void startInboundProcessing() {
        this.inboundScheduler.schedule(() -> {
            this.inboundReady.tryEmitValue(null);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.inputStream));
                while (!this.isClosing) {
                    try {
                        String line = reader.readLine();
                        if (line == null) break;
                        if (this.isClosing) {
                            break;
                        }
                        logger.debug("Received JSON message: {}", (Object)line);
                        try {
                            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(this.objectMapper, line);
                            if (this.inboundSink.tryEmitNext((Object)message).isSuccess()) continue;
                            this.logIfNotClosing("Failed to enqueue message");
                        }
                        catch (Exception e) {
                            this.logIfNotClosing("Error processing inbound message", e);
                        }
                    }
                    catch (IOException e) {
                        this.logIfNotClosing("Error reading from stdin", e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.logIfNotClosing("Error in inbound processing", e);
            }
            finally {
                this.isClosing = true;
                this.inboundSink.tryEmitComplete();
            }
        });
    }

    private void startOutboundProcessing() {
        Function<Flux, Flux> outboundConsumer = messages -> messages.doOnSubscribe(subscription -> this.outboundReady.tryEmitValue(null)).publishOn(this.outboundScheduler).handle((message, sink) -> {
            block9: {
                if (message != null && !this.isClosing) {
                    try {
                        String jsonMessage = this.objectMapper.writeValueAsString(message);
                        jsonMessage = jsonMessage.replace("\r\n", "\\n").replace("\n", "\\n").replace("\r", "\\n");
                        OutputStream outputStream = this.outputStream;
                        synchronized (outputStream) {
                            this.outputStream.write(jsonMessage.getBytes(StandardCharsets.UTF_8));
                            this.outputStream.write("\n".getBytes(StandardCharsets.UTF_8));
                            this.outputStream.flush();
                        }
                        sink.next(message);
                    }
                    catch (IOException e) {
                        if (!this.isClosing) {
                            logger.error("Error writing message", (Throwable)e);
                            sink.error((Throwable)new RuntimeException(e));
                            break block9;
                        }
                        logger.debug("Stream closed during shutdown", (Throwable)e);
                    }
                } else if (this.isClosing) {
                    sink.complete();
                }
            }
        }).doOnComplete(() -> {
            this.isClosing = true;
            this.outboundScheduler.dispose();
        }).doOnError(e -> {
            if (!this.isClosing) {
                logger.error("Error in outbound processing", e);
                this.isClosing = true;
                this.outboundScheduler.dispose();
            }
        }).map(msg -> (McpSchema.JSONRPCMessage)msg);
        outboundConsumer.apply(this.outboundSink.asFlux()).subscribe();
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            this.isClosing = true;
            logger.debug("Initiating graceful shutdown");
            this.inboundSink.tryEmitComplete();
            logger.debug("Graceful shutdown complete");
            return Mono.empty();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    @Override
    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    private void logIfNotClosing(String message, Exception e) {
        if (!this.isClosing) {
            logger.error(message, (Throwable)e);
        }
    }

    private void logIfNotClosing(String message) {
        if (!this.isClosing) {
            logger.error(message);
        }
    }
}

