/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.util.AbstractQueue;
import monix.reactive.observers.buffers.ConcurrentQueue$;
import org.jctools.queues.MessagePassingQueue;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}bAB\u0001\u0003\u0003\u0003\u0011!BA\bD_:\u001cWO\u001d:f]R\fV/Z;f\u0015\t\u0019A!A\u0004ck\u001a4WM]:\u000b\u0005\u00151\u0011!C8cg\u0016\u0014h/\u001a:t\u0015\t9\u0001\"\u0001\u0005sK\u0006\u001cG/\u001b<f\u0015\u0005I\u0011!B7p]&DXCA\u0006\u001b'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\ta\u0003E\u0002\u0018\u0001ai\u0011A\u0001\t\u00033ia\u0001\u0001B\u0003\u001c\u0001\t\u0007ADA\u0001B#\ti\u0002\u0005\u0005\u0002\u000e=%\u0011qD\u0004\u0002\b\u001d>$\b.\u001b8h!\ti\u0011%\u0003\u0002#\u001d\t\u0019\u0011I\\=\t\u000b\u0011\u0002a\u0011A\u0013\u0002\u000f%\u001cX)\u001c9usV\ta\u0005\u0005\u0002\u000eO%\u0011\u0001F\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0003A\"\u0001,\u0003\u0011\u0001x\u000e\u001c7\u0015\u0003aAQ!\f\u0001\u0007\u00029\nQa\u001c4gKJ$\"AJ\u0018\t\u000bAb\u0003\u0019\u0001\r\u0002\t\u0015dW-\u001c\u0005\u0006e\u00011\taM\u0001\u000eIJ\f\u0017N\u001c+p\u0005V4g-\u001a:\u0015\u0007Q:\u0014\t\u0005\u0002\u000ek%\u0011aG\u0004\u0002\u0005+:LG\u000fC\u00039c\u0001\u0007\u0011(\u0001\u0004ck\u001a4WM\u001d\t\u0004u}BR\"A\u001e\u000b\u0005qj\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003}9\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00015H\u0001\u0004Ck\u001a4WM\u001d\u0005\u0006\u0005F\u0002\raQ\u0001\u0006Y&l\u0017\u000e\u001e\t\u0003\u001b\u0011K!!\u0012\b\u0003\u0007%sGo\u0002\u0004H\u0005!\u0005!\u0001S\u0001\u0010\u0007>t7-\u001e:sK:$\u0018+^3vKB\u0011q#\u0013\u0004\u0007\u0003\tA\tA\u0001&\u0014\u0005%c\u0001\"B\nJ\t\u0003aE#\u0001%\t\u000b9KE\u0011A(\u0002\u000f1LW.\u001b;fIV\u0011\u0001k\u0015\u000b\u0003#R\u00032a\u0006\u0001S!\tI2\u000bB\u0003\u001c\u001b\n\u0007A\u0004C\u0003V\u001b\u0002\u00071)\u0001\u0005dCB\f7-\u001b;z\u0011\u00159\u0016\n\"\u0001Y\u0003%)hNY8v]\u0012,G-\u0006\u0002Z9R\t!\fE\u0002\u0018\u0001m\u0003\"!\u0007/\u0005\u000bm1&\u0019\u0001\u000f\u0007\tyKea\u0018\u0002\u0012\rJ|W.\u00112tiJ\f7\r^)vKV,WC\u00011d'\ti\u0016\rE\u0002\u0018\u0001\t\u0004\"!G2\u0005\u000bmi&\u0019\u0001\u000f\t\u0011\u0015l&\u0011!Q\u0001\n\u0019\f!\"\u001e8eKJd\u00170\u001b8h!\r9GNY\u0007\u0002Q*\u0011\u0011N[\u0001\u0005kRLGNC\u0001l\u0003\u0011Q\u0017M^1\n\u00055D'!D!cgR\u0014\u0018m\u0019;Rk\u0016,X\rC\u0003\u0014;\u0012\u0005q\u000e\u0006\u0002qeB\u0019\u0011/\u00182\u000e\u0003%CQ!\u001a8A\u0002\u0019DQ\u0001J/\u0005\u0002\u0015BQ!L/\u0005\u0002U$\"A\n<\t\u000bA\"\b\u0019\u00012\t\u000b)jF\u0011\u0001=\u0015\u0003\tDQAM/\u0005\u0002i$2\u0001N>~\u0011\u0015A\u0014\u00101\u0001}!\rQtH\u0019\u0005\u0006\u0005f\u0004\ra\u0011\u0004\u0006\u007f&3\u0011\u0011\u0001\u0002\u0018\rJ|W.T3tg\u0006<W\rU1tg&tw-U;fk\u0016,B!a\u0001\u0002\nM\u0019a0!\u0002\u0011\t]\u0001\u0011q\u0001\t\u00043\u0005%A!B\u000e\u007f\u0005\u0004a\u0002\"C3\u007f\u0005\u0003\u0005\u000b\u0011BA\u0007!\u0019\ty!!\b\u0002\b5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004rk\u0016,Xm\u001d\u0006\u0005\u0003/\tI\"A\u0004kGR|w\u000e\\:\u000b\u0005\u0005m\u0011aA8sO&!\u0011qDA\t\u0005MiUm]:bO\u0016\u0004\u0016m]:j]\u001e\fV/Z;f\u0011\u0019\u0019b\u0010\"\u0001\u0002$Q!\u0011QEA\u0014!\u0011\th0a\u0002\t\u000f\u0015\f\t\u00031\u0001\u0002\u000e!)AE C\u0001K!1QF C\u0001\u0003[!2AJA\u0018\u0011\u001d\u0001\u00141\u0006a\u0001\u0003\u000fAaA\u000b@\u0005\u0002\u0005MBCAA\u0004\u0011\u0019\u0011d\u0010\"\u0001\u00028Q)A'!\u000f\u0002>!9\u0001(!\u000eA\u0002\u0005m\u0002\u0003\u0002\u001e@\u0003\u000fAaAQA\u001b\u0001\u0004\u0019\u0005")
public abstract class ConcurrentQueue<A> {
    public static <A> ConcurrentQueue<A> unbounded() {
        return ConcurrentQueue$.MODULE$.unbounded();
    }

    public static <A> ConcurrentQueue<A> limited(int n) {
        return ConcurrentQueue$.MODULE$.limited(n);
    }

    public abstract boolean isEmpty();

    public abstract A poll();

    public abstract boolean offer(A var1);

    public abstract void drainToBuffer(Buffer<A> var1, int var2);

    public static final class FromAbstractQueue<A>
    extends ConcurrentQueue<A> {
        private final AbstractQueue<A> underlying;

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.offer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.poll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            for (int fetched = 0; fetched < limit; ++fetched) {
                Object next = this.underlying.poll();
                if (next == null) {
                    return;
                }
                buffer.$plus$eq(next);
            }
        }

        public FromAbstractQueue(AbstractQueue<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static final class FromMessagePassingQueue<A>
    extends ConcurrentQueue<A> {
        private final MessagePassingQueue<A> underlying;

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.relaxedOffer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.relaxedPoll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            MessagePassingQueue.Consumer consumer = new MessagePassingQueue.Consumer<A>(this, buffer){
                private final Buffer buffer$1;

                public void accept(A e) {
                    this.buffer$1.$plus$eq(e);
                }
                {
                    this.buffer$1 = buffer$1;
                }
            };
            this.underlying.drain(consumer, limit);
        }

        public FromMessagePassingQueue(MessagePassingQueue<A> underlying) {
            this.underlying = underlying;
        }
    }
}

