/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SpringBootUtil {
    public static boolean doesSpringBootRepackageGoalExecutionExist(MavenProject project) {
        return MavenProjectUtil.doesPluginGoalExecutionExist(project, "org.springframework.boot:spring-boot-maven-plugin", "repackage");
    }

    public static int getSpringBootMavenPluginVersion(MavenProject project) {
        return MavenProjectUtil.getMajorPluginVersion(project, "org.springframework.boot:spring-boot-maven-plugin");
    }

    public static String getSpringBootMavenPluginClassifier(MavenProject project, Log log) {
        String classifier = null;
        try {
            classifier = MavenProjectUtil.getPluginGoalConfigurationString(project, "org.springframework.boot:spring-boot-maven-plugin", "repackage", "classifier");
        }
        catch (PluginScenarioException e) {
            log.debug((CharSequence)"No classifier found for spring-boot-maven-plugin");
        }
        return classifier;
    }

    public static File getSpringBootUberJAR(MavenProject project, Log log) {
        File fatArchive = SpringBootUtil.getSpringBootUberJARLocation(project, log);
        if (io.openliberty.tools.common.plugins.util.SpringBootUtil.isSpringBootUberJar((File)fatArchive)) {
            log.info((CharSequence)("Found Spring Boot Uber JAR: " + fatArchive.getAbsolutePath()));
            return fatArchive;
        }
        if (fatArchive.exists()) {
            log.warn((CharSequence)("The file at the following location is not a Spring Boot Uber JAR: " + fatArchive.getAbsolutePath()));
        } else {
            log.warn((CharSequence)("Spring Boot Uber JAR was not found in expected location: " + fatArchive.getAbsolutePath()));
        }
        return null;
    }

    public static File getSpringBootUberJARLocation(MavenProject project, Log log) {
        String classifier = SpringBootUtil.getSpringBootMavenPluginClassifier(project, log);
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + classifier + "." + project.getArtifact().getArtifactHandler().getExtension());
    }

    public static String getLibertySpringBootFeature(int springBootMajorVersion) {
        if (SpringBootUtil.isSpringBoot1(springBootMajorVersion)) {
            return "springBoot-1.5";
        }
        if (SpringBootUtil.isSpringBoot2plus(springBootMajorVersion)) {
            return "springBoot-" + springBootMajorVersion + ".0";
        }
        return null;
    }

    public static boolean isSpringBoot1(int springBootMajorVersion) {
        return springBootMajorVersion == 1;
    }

    public static boolean isSpringBoot2plus(int springBootMajorVersion) {
        return springBootMajorVersion > 1;
    }
}

