/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.bean.tcp.TcpMeta;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.exception.HttpRequestCreateException;
import io.parallec.core.exception.TcpUdpRequestCreateException;
import io.parallec.core.resources.TcpUdpSshPingResourceStore;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcStringUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TcpWorker
extends UntypedActor {
    private int actorMaxOperationTimeoutSec;
    private final TcpMeta tcpMeta;
    private String targetHost;
    private static Logger logger = LoggerFactory.getLogger(TcpWorker.class);
    private ActorRef sender = null;
    private Throwable cause;
    private int tryCount = 0;
    private Cancellable timeoutMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private boolean sentReply = false;
    private Channel channel = null;
    private StringBuilder responseSb = new StringBuilder();

    public TcpWorker(int actorMaxOperationTimeoutSec, TcpMeta tcpMeta, String targetHost) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.tcpMeta = tcpMeta;
        this.targetHost = targetHost;
    }

    public ClientBootstrap bootStrapTcpClient() throws HttpRequestCreateException {
        ClientBootstrap tcpClient = null;
        try {
            tcpClient = new ClientBootstrap(this.tcpMeta.getChannelFactory());
            tcpClient.setPipelineFactory((ChannelPipelineFactory)new MyPipelineFactory((Timer)TcpUdpSshPingResourceStore.getInstance().getTimer(), this, this.tcpMeta.getTcpIdleTimeoutSec()));
            tcpClient.setOption("connectTimeoutMillis", (Object)this.tcpMeta.getTcpConnectTimeoutMillis());
            tcpClient.setOption("tcpNoDelay", (Object)true);
        }
        catch (Exception t) {
            throw new TcpUdpRequestCreateException("Error in creating request in Tcpworker.  If tcpClient is null. Then fail to create.", t);
        }
        return tcpClient;
    }

    public void onReceive(Object message) throws Exception {
        block12: {
            try {
                if (message instanceof RequestWorkerMsgType) {
                    switch ((RequestWorkerMsgType)((Object)message)) {
                        case PROCESS_REQUEST: {
                            ++this.tryCount;
                            if (this.tryCount == 1) {
                                this.sender = this.getSender();
                                ClientBootstrap tcpClient = this.bootStrapTcpClient();
                                ChannelFuture future = tcpClient.connect((SocketAddress)new InetSocketAddress(this.targetHost, this.tcpMeta.getTcpPort()));
                                this.timeoutDuration = Duration.create((long)this.actorMaxOperationTimeoutSec, (TimeUnit)TimeUnit.SECONDS);
                                this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                                this.channel = future.awaitUninterruptibly().getChannel();
                                ChannelFuture requestFuture = null;
                                requestFuture = this.channel.write((Object)(this.tcpMeta.getCommand() + "\r\n"));
                                if (requestFuture != null) {
                                    requestFuture.await();
                                    break;
                                }
                                break block12;
                            }
                            TcpWorker.getLogger().error("duplicated PROCESS_REQUEST msg. ignore...");
                            break;
                        }
                        case CANCEL: {
                            if (this.sender == null) {
                                this.sender = this.getSender();
                            }
                            TcpWorker.getLogger().info("TCP Request was CANCELLED.................{}", (Object)this.targetHost);
                            this.cancelCancellable();
                            this.reply(null, true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1);
                            break;
                        }
                        case PROCESS_ON_EXCEPTION: {
                            String errorSummary = PcErrorMsgUtils.replaceErrorMsg(this.cause.toString());
                            String stackTrace = PcStringUtils.printStackTrace(this.cause);
                            this.cancelCancellable();
                            this.reply(null, true, errorSummary, stackTrace, "NA", -1);
                            break;
                        }
                        case PROCESS_ON_TIMEOUT: {
                            TcpWorker.getLogger().error("PROCESS_ON_TIMEOUT.................{}", (Object)this.targetHost);
                            this.cancelCancellable();
                            String errorMsg = String.format("TcpWorker Timedout after %d SEC (no response but no exception catched). Check URL: may be very slow or stuck.", this.actorMaxOperationTimeoutSec);
                            this.reply(null, true, errorMsg, errorMsg, "NA", -1);
                            break;
                        }
                        default: {
                            this.sender = this.getSender();
                            this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for on " + this.targetHost);
                            this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
                            break;
                        }
                    }
                    break block12;
                }
                this.unhandled(message);
                this.sender = this.getSender();
                this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for TCP on " + this.targetHost);
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
            catch (Exception e) {
                this.cause = e;
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
        }
    }

    public void cancelCancellable() {
        if (this.timeoutMessageCancellable != null) {
            this.timeoutMessageCancellable.cancel();
        }
    }

    private void reply(String response, boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        if (!this.sentReply) {
            this.sentReply = true;
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().awaitUninterruptibly();
            }
            ResponseOnSingeRequest res = new ResponseOnSingeRequest(response, error, errorMessage, stackTrace, statusCode, statusCodeInt, PcDateUtils.getNowDateTimeStrStandard(), null);
            if (!this.getContext().system().deadLetters().equals((Object)this.sender)) {
                this.sender.tell((Object)res, this.getSelf());
            }
            if (this.getContext() != null) {
                this.getContext().stop(this.getSelf());
            }
        }
    }

    public void onComplete(String response, boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        this.cancelCancellable();
        this.reply(response, error, errorMessage, stackTrace, statusCode, statusCodeInt);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        TcpWorker.logger = logger;
    }

    public static class TcpChannelHandler
    extends SimpleChannelHandler {
        public boolean hasCaughtException = false;
        private final TcpWorker tcpWorker;
        private int msgRecvCount = 0;

        public TcpChannelHandler(TcpWorker tcpWorker) {
            this.tcpWorker = tcpWorker;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            this.tcpWorker.responseSb.append(e.getMessage().toString() + "\n");
            logger.debug("DONE." + ++this.msgRecvCount);
            logger.debug("MSG_RECEIVED_AT_TCP_CLIENT: {}", (Object)e.getMessage().toString());
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            logger.debug("channel is closed. ");
            int statusCodeInt = 0;
            String statusCode = statusCodeInt + " SUCCESSFUL";
            this.tcpWorker.onComplete(this.tcpWorker.responseSb.toString(), false, null, null, statusCode, statusCodeInt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (!this.hasCaughtException) {
                this.hasCaughtException = true;
                e.getChannel().close();
                String errMsg = e.getCause().getLocalizedMessage();
                logger.debug("TCP Handler exceptionCaught: {} . ", (Object)errMsg);
                int statusCodeInt = 1;
                String statusCode = statusCodeInt + " FAILURE";
                this.tcpWorker.onComplete(this.tcpWorker.responseSb.toString(), true, errMsg, errMsg, statusCode, statusCodeInt);
            }
        }
    }

    public static class MyIdleHandler
    extends IdleStateAwareChannelHandler {
        private final TcpWorker tcpWorker;

        public MyIdleHandler(TcpWorker tcpWorker) {
            this.tcpWorker = tcpWorker;
        }

        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            logger.info("In IDLE event handler for TCP...");
            if (e.getState() == IdleState.ALL_IDLE) {
                int statusCodeInt = 0;
                String statusCode = statusCodeInt + " SUCCESSFUL";
                String errMsg = "idleTimeout to finish";
                this.tcpWorker.onComplete(this.tcpWorker.responseSb.toString(), false, errMsg, errMsg, statusCode, statusCodeInt);
            }
        }
    }

    public static class MyPipelineFactory
    implements ChannelPipelineFactory {
        private final ChannelHandler idleStateHandler;
        private final TcpWorker tcpWorker;
        private final MyIdleHandler myIdleHandler;

        public MyPipelineFactory(Timer timer, TcpWorker tcpWorker, int idleTimeoutSec) {
            this.tcpWorker = tcpWorker;
            this.idleStateHandler = new IdleStateHandler(timer, 0, 0, idleTimeoutSec);
            this.myIdleHandler = new MyIdleHandler(tcpWorker);
        }

        public ChannelPipeline getPipeline() {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("idleTimer", this.idleStateHandler);
            pipeline.addLast("idleHandler", (ChannelHandler)this.myIdleHandler);
            pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(1024, Delimiters.lineDelimiter()));
            pipeline.addLast("stringDecoder", TcpMeta.stringDecoder);
            pipeline.addLast("stringEncoder", TcpMeta.stringEncoder);
            pipeline.addLast("handler", (ChannelHandler)new TcpChannelHandler(this.tcpWorker));
            return pipeline;
        }
    }
}

