/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean.ping;

import io.parallec.core.bean.ping.PingMode;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingMeta {
    private static Logger logger = LoggerFactory.getLogger(PingMeta.class);
    private PingMode mode = null;
    private Integer pingTimeoutMillis = null;
    private Integer numRetries = null;

    public boolean validation() throws ParallelTaskInvalidException {
        if (this.mode == null) {
            logger.info("SET DEFAULT PING MODE: INET_ADDRESS_REACHABLE_NEED_ROOT.WARNING. MUST run as ROOT for accuracy. ");
            this.mode = ParallecGlobalConfig.pingModeDefault;
        }
        if (this.pingTimeoutMillis == null) {
            logger.info("SET DEFAULT PING TIMEOUT: 500ms ");
            this.pingTimeoutMillis = ParallecGlobalConfig.pingTimeoutMillisDefault;
        }
        if (this.numRetries == null) {
            logger.info("SET DEFAULT PING NUM OF RETRIES: 1 ");
            this.numRetries = ParallecGlobalConfig.pingNumRetriesDefault;
        }
        return true;
    }

    public PingMode getMode() {
        return this.mode;
    }

    public void setMode(PingMode mode) {
        this.mode = mode;
    }

    public Integer getPingTimeoutMillis() {
        return this.pingTimeoutMillis;
    }

    public void setPingTimeoutMillis(Integer pingTimeoutMillis) {
        this.pingTimeoutMillis = pingTimeoutMillis;
    }

    public Integer getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(Integer numRetries) {
        this.numRetries = numRetries;
    }
}

