/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean.ssh;

import io.parallec.core.bean.ssh.SshLoginType;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;

public class SshMeta {
    private String commandLine;
    private String userName;
    private int sshPort;
    private SshLoginType sshLoginType;
    private String privKeyRelativePath;
    private String password;
    private boolean privKeyUsePassphrase;
    private boolean runAsSuperUser;
    private String passphrase;
    private int sshConnectionTimeoutMillis;

    public boolean isPrivKeyUsePassphrase() {
        return this.privKeyUsePassphrase;
    }

    public void setPrivKeyUsePassphrase(boolean privKeyUsePassphrase) {
        this.privKeyUsePassphrase = privKeyUsePassphrase;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public boolean isRunAsSuperUser() {
        return this.runAsSuperUser;
    }

    public void setRunAsSuperUser(boolean runAsSuperUser) {
        this.runAsSuperUser = runAsSuperUser;
    }

    public SshMeta(String commandLine, String userName, int sshPort, SshLoginType sshLoginType, String privKeyRelativePath, String password, boolean privKeyUsePassphrase, String passphrase, int sshConnectionTimeoutMillis, boolean runAsSuperUser) {
        this.commandLine = commandLine;
        this.userName = userName;
        this.sshPort = sshPort;
        this.sshLoginType = sshLoginType;
        this.privKeyRelativePath = privKeyRelativePath;
        this.password = password;
        this.privKeyUsePassphrase = privKeyUsePassphrase;
        this.passphrase = passphrase;
        this.sshConnectionTimeoutMillis = sshConnectionTimeoutMillis;
        this.runAsSuperUser = runAsSuperUser;
    }

    public SshMeta() {
        this.commandLine = null;
        this.userName = null;
        this.sshPort = 22;
        this.sshLoginType = null;
        this.privKeyRelativePath = null;
        this.password = null;
        this.privKeyUsePassphrase = false;
        this.passphrase = null;
        this.runAsSuperUser = false;
        this.sshConnectionTimeoutMillis = ParallecGlobalConfig.sshConnectionTimeoutMillisDefault;
    }

    public boolean validation() throws ParallelTaskInvalidException {
        if (this.commandLine == null) {
            throw new ParallelTaskInvalidException("commandSshLine is null for ssh");
        }
        if (this.sshLoginType == null) {
            throw new ParallelTaskInvalidException("sshLoginType is null for ssh");
        }
        if (this.userName == null) {
            throw new ParallelTaskInvalidException("userName is null for ssh. UserName is required for both key/password based login");
        }
        if (this.sshLoginType == SshLoginType.PASSWORD && this.password == null) {
            throw new ParallelTaskInvalidException("use password but it is null for ssh");
        }
        if (this.sshLoginType == SshLoginType.KEY && this.privKeyRelativePath == null) {
            throw new ParallelTaskInvalidException("use public key but private key path is null for ssh");
        }
        if (this.sshLoginType == SshLoginType.KEY && this.privKeyUsePassphrase && this.passphrase == null) {
            throw new ParallelTaskInvalidException("use public key and also with private key passphrase but it is null for ssh");
        }
        return true;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SshLoginType getSshLoginType() {
        return this.sshLoginType;
    }

    public void setSshLoginType(SshLoginType sshLoginType) {
        this.sshLoginType = sshLoginType;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getPrivKeyRelativePath() {
        return this.privKeyRelativePath;
    }

    public void setPrivKeyRelativePath(String privKeyRelativePath) {
        this.privKeyRelativePath = privKeyRelativePath;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPrivKeyAbsPath() {
        String workingDir = System.getProperty("user.dir");
        return workingDir + "/" + this.getPrivKeyRelativePath();
    }

    public int getSshConnectionTimeoutMillis() {
        return this.sshConnectionTimeoutMillis;
    }

    public void setSshConnectionTimeoutMillis(int sshConnectionTimeoutMillis) {
        this.sshConnectionTimeoutMillis = sshConnectionTimeoutMillis;
    }
}

