/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.commander.workflow;

import io.parallec.core.ParallelTask;
import io.parallec.core.actor.message.NodeReqResponse;
import io.parallec.core.bean.StrStrMap;
import io.parallec.core.util.PcDateUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarReplacementProvider {
    private static Logger logger = LoggerFactory.getLogger(VarReplacementProvider.class);
    private static final VarReplacementProvider instance = new VarReplacementProvider();

    public static VarReplacementProvider getInstance() {
        return instance;
    }

    private VarReplacementProvider() {
    }

    public void updateRequestWithReplacement(ParallelTask task, boolean useReplacementVarMap, Map<String, String> replacementVarMap, boolean useReplacementVarMapNodeSpecific, Map<String, StrStrMap> replacementVarMapNodeSpecific) {
        try {
            if (useReplacementVarMap && replacementVarMap != null) {
                for (Map.Entry<String, String> entry : replacementVarMap.entrySet()) {
                    String replaceVarKey = entry.getKey();
                    String replaceVarValue = entry.getValue();
                    VarReplacementProvider.getInstance().updateRequestByAddingReplaceVarPair(task, replaceVarKey, replaceVarValue);
                }
            }
            if (useReplacementVarMapNodeSpecific && replacementVarMapNodeSpecific != null) {
                VarReplacementProvider.getInstance().updateRequestByAddingReplaceVarPairNodeSpecific(task, replacementVarMapNodeSpecific);
            }
        }
        catch (Exception e) {
            logger.error(" exception updateRequestWithReplacement ", (Throwable)e);
        }
    }

    public void updateRequestByAddingReplaceVarPair(ParallelTask task, String replaceVarKey, String replaceVarValue) {
        Map<String, NodeReqResponse> taskResult = task.getParallelTaskResult();
        for (Map.Entry<String, NodeReqResponse> entry : taskResult.entrySet()) {
            NodeReqResponse nodeReqResponse = entry.getValue();
            nodeReqResponse.getRequestParameters().put("REPLACE-VAR_" + replaceVarKey, replaceVarValue);
            nodeReqResponse.getRequestParameters().put("NODE_REQUEST_WILL_EXECUTE", Boolean.toString(true));
        }
    }

    public void updateRequestByAddingReplaceVarPairNodeSpecific(ParallelTask task, Map<String, StrStrMap> replacementVarMapNodeSpecific) {
        Map<String, NodeReqResponse> taskResult = task.getParallelTaskResult();
        for (Map.Entry<String, NodeReqResponse> entry : taskResult.entrySet()) {
            String fqdn = entry.getKey();
            StrStrMap replacementVarMapForThisNode = replacementVarMapNodeSpecific.get(fqdn);
            if (replacementVarMapForThisNode == null) {
                logger.info("replacementVarMapForThisNode is null in  for host " + fqdn);
                continue;
            }
            for (Map.Entry<String, String> entryReplaceMap : replacementVarMapForThisNode.getMap().entrySet()) {
                String replaceVarKey = entryReplaceMap.getKey();
                String replaceVarValue = entryReplaceMap.getValue();
                NodeReqResponse nodeReqResponse = entry.getValue();
                if (replaceVarKey.equalsIgnoreCase("NA")) {
                    logger.info("Replace NA means to disable this item." + PcDateUtils.getNowDateTimeStrStandard());
                    nodeReqResponse.getRequestParameters().put("NODE_REQUEST_EXECUTE_MSG", "!!! SAFEGUARD: NOTE: REQUEST WILL NOT EXECUTE: because NODE_REQUEST_EXECUTE_MSG_DETAIL_REPLACEMENT_VAR_VALUE_NA.");
                    nodeReqResponse.getRequestParameters().put("NODE_REQUEST_WILL_EXECUTE", Boolean.toString(false));
                    continue;
                }
                nodeReqResponse.getRequestParameters().put("REPLACE-VAR_" + replaceVarKey, replaceVarValue);
                if (replacementVarMapForThisNode.getMap().keySet().contains("NA")) {
                    nodeReqResponse.getRequestParameters().put("NODE_REQUEST_WILL_EXECUTE", Boolean.toString(false));
                    continue;
                }
                nodeReqResponse.getRequestParameters().put("NODE_REQUEST_WILL_EXECUTE", Boolean.toString(true));
            }
        }
    }
}

