/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.task;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.pattern.Patterns;
import akka.util.Timeout;
import io.parallec.core.ParallelTask;
import io.parallec.core.actor.ActorConfig;
import io.parallec.core.actor.ExecutionManager;
import io.parallec.core.actor.message.InitialRequestToManager;
import io.parallec.core.actor.message.ResponseFromManager;
import io.parallec.core.bean.StrStrMap;
import io.parallec.core.commander.workflow.InternalDataProvider;
import io.parallec.core.commander.workflow.VarReplacementProvider;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.task.CapacityAwareTaskScheduler;
import io.parallec.core.task.ParallelTaskState;
import io.parallec.core.task.TaskErrorMeta;
import io.parallec.core.util.DaemonThreadFactory;
import io.parallec.core.util.PcDateUtils;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ParallelTaskManager {
    private static Logger logger;
    private static final ParallelTaskManager instance;
    private ScheduledExecutorService scheduler;
    private final Queue<ParallelTask> waitQ = new ConcurrentLinkedQueue<ParallelTask>();
    private final ConcurrentHashMap<String, ParallelTask> inprogressTaskMap = new ConcurrentHashMap();

    public static ParallelTaskManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParallelTaskManager() {
        ParallelTaskManager parallelTaskManager = this;
        synchronized (parallelTaskManager) {
            logger = LoggerFactory.getLogger(ParallelTaskManager.class);
        }
        logger.info("Initialized ParallelTaskManager...");
    }

    public synchronized void initTaskSchedulerIfNot() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.getInstance());
            CapacityAwareTaskScheduler runner = new CapacityAwareTaskScheduler();
            this.scheduler.scheduleAtFixedRate(runner, ParallecGlobalConfig.schedulerInitDelay, ParallecGlobalConfig.schedulerCheckInterval, TimeUnit.MILLISECONDS);
            logger.info("initialized daemon task scheduler to evaluate waitQ tasks.");
        }
    }

    public synchronized void shutdownTaskScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            logger.info("shutdowned the task scheduler. No longer accepting new tasks");
            this.scheduler = null;
        }
    }

    public ParallelTask getTaskFromInProgressMap(String jobId) {
        if (!this.inprogressTaskMap.containsKey(jobId)) {
            return null;
        }
        return this.inprogressTaskMap.get(jobId);
    }

    public int getTotalUsedCapacity() {
        int totalCapacity = 0;
        for (Map.Entry<String, ParallelTask> entry : this.inprogressTaskMap.entrySet()) {
            ParallelTask task = entry.getValue();
            if (task == null) continue;
            totalCapacity += task.capacityUsed();
        }
        return totalCapacity;
    }

    public int getRemainingCapacity() {
        return ParallecGlobalConfig.maxCapacity - this.getTotalUsedCapacity();
    }

    public synchronized void addTaskToInProgressMap(String jobId, ParallelTask task) {
        this.inprogressTaskMap.put(jobId, task);
    }

    public synchronized void removeTaskFromInProgressMap(String jobId) {
        this.inprogressTaskMap.remove(jobId);
    }

    public synchronized void cleanInprogressJobMap() {
        this.inprogressTaskMap.clear();
    }

    public synchronized void cleanWaitTaskQueue() {
        for (ParallelTask task : this.waitQ) {
            task.setState(ParallelTaskState.COMPLETED_WITH_ERROR);
            task.getTaskErrorMetas().add(new TaskErrorMeta(TaskErrorMeta.TaskErrorType.USER_CANCELED, "NA"));
            logger.info("task {} removed from wait q. This task has been marked as USER CANCELED.", (Object)task.getTaskId());
        }
        this.waitQ.clear();
    }

    public synchronized boolean removeTaskFromWaitQ(ParallelTask taskTobeRemoved) {
        boolean removed = false;
        for (ParallelTask task : this.waitQ) {
            if (task.getTaskId() != taskTobeRemoved.getTaskId()) continue;
            task.setState(ParallelTaskState.COMPLETED_WITH_ERROR);
            task.getTaskErrorMetas().add(new TaskErrorMeta(TaskErrorMeta.TaskErrorType.USER_CANCELED, "NA"));
            logger.info("task {} removed from wait q. This task has been marked as USER CANCELED.", (Object)task.getTaskId());
            removed = true;
        }
        return removed;
    }

    public ResponseFromManager generateUpdateExecuteTask(ParallelTask task) {
        ParallelTaskManager.getInstance().addTaskToInProgressMap(task.getTaskId(), task);
        logger.info("Added task {} to the running inprogress map...", (Object)task.getTaskId());
        boolean useReplacementVarMap = false;
        boolean useReplacementVarMapNodeSpecific = false;
        Map<String, StrStrMap> replacementVarMapNodeSpecific = null;
        Map<String, String> replacementVarMap = null;
        ResponseFromManager batchResponseFromManager = null;
        switch (task.getRequestReplacementType()) {
            case UNIFORM_VAR_REPLACEMENT: {
                useReplacementVarMap = true;
                useReplacementVarMapNodeSpecific = false;
                replacementVarMap = task.getReplacementVarMap();
                break;
            }
            case TARGET_HOST_SPECIFIC_VAR_REPLACEMENT: {
                useReplacementVarMap = false;
                useReplacementVarMapNodeSpecific = true;
                replacementVarMapNodeSpecific = task.getReplacementVarMapNodeSpecific();
                break;
            }
            case NO_REPLACEMENT: {
                useReplacementVarMap = false;
                useReplacementVarMapNodeSpecific = false;
                break;
            }
            default: {
                logger.error("error request replacement type. default as no replacement");
            }
        }
        InternalDataProvider dp = InternalDataProvider.getInstance();
        dp.genNodeDataMap(task);
        VarReplacementProvider.getInstance().updateRequestWithReplacement(task, useReplacementVarMap, replacementVarMap, useReplacementVarMapNodeSpecific, replacementVarMapNodeSpecific);
        batchResponseFromManager = this.sendTaskToExecutionManager(task);
        this.removeTaskFromInProgressMap(task.getTaskId());
        logger.info("Removed task {} from the running inprogress map... . This task should be garbage collected if there are no other pointers.", (Object)task.getTaskId());
        return batchResponseFromManager;
    }

    public Queue<ParallelTask> getWaitQ() {
        return this.waitQ;
    }

    public Map<String, ParallelTask> getInprogressTaskMap() {
        return this.inprogressTaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseFromManager sendTaskToExecutionManager(ParallelTask task) {
        ResponseFromManager commandResponseFromManager;
        block9: {
            commandResponseFromManager = null;
            ActorRef executionManager = null;
            try {
                logger.info("!!STARTED sendAgentCommandToManager : " + task.getTaskId() + " at " + PcDateUtils.getNowDateTimeStr());
                executionManager = ActorConfig.createAndGetActorSystem().actorOf(Props.create(ExecutionManager.class, (Object[])new Object[]{task}), "ExecutionManager-" + task.getTaskId());
                FiniteDuration duration = Duration.create((long)task.getConfig().getTimeoutAskManagerSec(), (TimeUnit)TimeUnit.SECONDS);
                Future future = Patterns.ask((ActorRef)executionManager, (Object)new InitialRequestToManager(task), (Timeout)new Timeout(duration));
                task.executionManager = executionManager;
                commandResponseFromManager = (ResponseFromManager)Await.result((Awaitable)future, (Duration)duration);
                logger.info("!!COMPLETED sendTaskToExecutionManager : " + task.getTaskId() + " at " + PcDateUtils.getNowDateTimeStr() + "  \t\t  GenericResponseMap in future size: " + commandResponseFromManager.getResponseCount());
            }
            catch (Exception ex) {
                logger.error("Exception in sendTaskToExecutionManager {} details {}: ", (Object)ex, (Object)ex);
                break block9;
            }
            finally {
                if (executionManager != null && !executionManager.isTerminated()) {
                    ActorConfig.createAndGetActorSystem().stop(executionManager);
                }
                if (task.getConfig().isAutoSaveLogToLocal()) {
                    task.saveLogToLocal();
                }
            }
            if (executionManager != null && !executionManager.isTerminated()) {
                ActorConfig.createAndGetActorSystem().stop(executionManager);
            }
            if (task.getConfig().isAutoSaveLogToLocal()) {
                task.saveLogToLocal();
            }
        }
        return commandResponseFromManager;
    }

    static {
        instance = new ParallelTaskManager();
    }
}

