/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core;

import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.ParallelTaskBuilder;
import io.parallec.core.RequestProtocol;
import io.parallec.core.actor.ActorConfig;
import io.parallec.core.monitor.MonitorProvider;
import io.parallec.core.resources.HttpClientStore;
import io.parallec.core.resources.HttpClientType;
import io.parallec.core.resources.HttpMethod;
import io.parallec.core.resources.TcpUdpSshPingResourceStore;
import io.parallec.core.task.ParallelTaskManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelClient {
    private static Logger logger = LoggerFactory.getLogger(ParallelClient.class);
    public ParallelTaskManager taskManager = ParallelTaskManager.getInstance();
    public HttpClientStore httpClientStore = HttpClientStore.getInstance();
    public TcpUdpSshPingResourceStore tcpSshPingResourceStore = TcpUdpSshPingResourceStore.getInstance();
    public static AtomicBoolean isClosed = new AtomicBoolean(true);

    public ParallelClient() {
        this.initialize();
    }

    public void initialize() {
        if (isClosed.get()) {
            logger.info("Initialing Parallel Client Resources: actor system, HttpClientStore, Task Manager ....");
            ActorConfig.createAndGetActorSystem();
            this.httpClientStore.init();
            this.tcpSshPingResourceStore.init();
            ParallelTaskManager.getInstance();
            isClosed.set(false);
            logger.info("Parallel Client Resources has been initialized.");
        } else {
            logger.debug("NO OP. Parallel Client Resources has already been initialized.");
        }
    }

    public void releaseExternalResources() {
        if (!isClosed.get()) {
            logger.info("Releasing all ParallelClient resources... ");
            ActorConfig.shutDownActorSystemForce();
            this.httpClientStore.shutdown();
            this.tcpSshPingResourceStore.shutdown();
            this.taskManager.cleanWaitTaskQueue();
            this.taskManager.cleanInprogressJobMap();
            isClosed.set(true);
            logger.info("Have released all ParallelClient resources (actor system + async+sync http client + task queue)\nNow safe to stop your application.");
        } else {
            logger.debug("NO OP. ParallelClient resources have already been released.");
        }
    }

    public void reinitIfClosed() {
        if (isClosed.get()) {
            logger.info("External Resource was released. Now Re-initializing resources ...");
            ActorConfig.createAndGetActorSystem();
            this.httpClientStore.reinit();
            this.tcpSshPingResourceStore.reinit();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("error reinit httpClientStore", (Throwable)e);
            }
            isClosed.set(false);
            logger.info("Parallel Client Resources has been reinitialized.");
        } else {
            logger.debug("NO OP. Resource was not released.");
        }
    }

    public ParallelTaskBuilder prepareSsh() {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.setProtocol(RequestProtocol.SSH);
        return cb;
    }

    public ParallelTaskBuilder preparePing() {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.setProtocol(RequestProtocol.PING);
        return cb;
    }

    public ParallelTaskBuilder prepareTcp(String command) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.setProtocol(RequestProtocol.TCP);
        cb.getTcpMeta().setCommand(command);
        return cb;
    }

    public ParallelTaskBuilder prepareUdp(String command) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.setProtocol(RequestProtocol.UDP);
        cb.getUdpMeta().setCommand(command);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpGet(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.GET);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpPost(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.POST);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpDelete(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.DELETE);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpPut(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.PUT);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpHead(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.HEAD);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public ParallelTaskBuilder prepareHttpOptions(String url) {
        this.reinitIfClosed();
        ParallelTaskBuilder cb = new ParallelTaskBuilder();
        cb.getHttpMeta().setHttpMethod(HttpMethod.OPTIONS);
        cb.getHttpMeta().setRequestUrlPostfix(url);
        return cb;
    }

    public void setCustomClientFast(AsyncHttpClient client) {
        this.httpClientStore.setCustomClientFast(client);
    }

    public void setCustomClientSlow(AsyncHttpClient client) {
        this.httpClientStore.setCustomClientSlow(client);
    }

    public void setHttpClientTypeCurrentDefault(HttpClientType type) {
        this.httpClientStore.setHttpClientTypeCurrentDefault(type);
    }

    public void reinitHttpClients() {
        this.httpClientStore.reinit();
    }

    public void cleanInprogressJobMap() {
        this.taskManager.cleanInprogressJobMap();
    }

    public void cleanWaitTaskQueue() {
        this.taskManager.cleanWaitTaskQueue();
    }

    public HttpClientStore getHttpClientStore() {
        return this.httpClientStore;
    }

    public String logHealth() {
        return MonitorProvider.getInstance().getHealthMemory();
    }

    public int getRunningJobCount() {
        return ParallelTaskManager.getInstance().getInprogressTaskMap().entrySet().size();
    }
}

