/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import com.google.common.base.Strings;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.util.AsyncHttpProviderUtils;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.bean.ResponseHeaderMeta;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.exception.HttpRequestCreateException;
import io.parallec.core.resources.HttpMethod;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcHttpUtils;
import io.parallec.core.util.PcStringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class HttpWorker
extends UntypedActor {
    private int actorMaxOperationTimeoutSec;
    private final AsyncHttpClient client;
    private final String requestUrl;
    private final HttpMethod httpMethod;
    private final String postData;
    private static Logger logger = LoggerFactory.getLogger(HttpWorker.class);
    private final Map<String, String> httpHeaderMap = new HashMap<String, String>();
    private final ResponseHeaderMeta responseHeaderMeta;
    private ActorRef sender = null;
    private Throwable cause;
    private int tryCount = 0;
    private Cancellable timeoutMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private boolean sentReply = false;
    ListenableFuture<ResponseOnSingeRequest> responseFuture = null;

    public HttpWorker(int actorMaxOperationTimeoutSec, AsyncHttpClient client, String requestUrl, HttpMethod httpMethod, String postData, Map<String, String> httpHeaderMap, ResponseHeaderMeta responseHeaderMeta) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.client = client;
        this.requestUrl = requestUrl;
        this.httpMethod = httpMethod;
        this.postData = postData;
        if (httpHeaderMap != null) {
            this.httpHeaderMap.putAll(httpHeaderMap);
        }
        this.responseHeaderMeta = responseHeaderMeta;
    }

    public AsyncHttpClient.BoundRequestBuilder createRequest() throws HttpRequestCreateException {
        AsyncHttpClient.BoundRequestBuilder builder = null;
        HttpWorker.getLogger().debug("AHC completeUrl " + this.requestUrl);
        try {
            switch (this.httpMethod) {
                case GET: {
                    builder = this.client.prepareGet(this.requestUrl);
                    break;
                }
                case POST: {
                    builder = this.client.preparePost(this.requestUrl);
                    break;
                }
                case PUT: {
                    builder = this.client.preparePut(this.requestUrl);
                    break;
                }
                case HEAD: {
                    builder = this.client.prepareHead(this.requestUrl);
                    break;
                }
                case OPTIONS: {
                    builder = this.client.prepareOptions(this.requestUrl);
                    break;
                }
                case DELETE: {
                    builder = this.client.prepareDelete(this.requestUrl);
                    break;
                }
            }
            PcHttpUtils.addHeaders(builder, this.httpHeaderMap);
            if (!Strings.isNullOrEmpty((String)this.postData)) {
                builder.setBody(this.postData);
            }
        }
        catch (Exception t) {
            throw new HttpRequestCreateException("Error in creating request in Httpworker.  If BoundRequestBuilder is null. Then fail to create.", t);
        }
        return builder;
    }

    public void onReceive(Object message) throws Exception {
        try {
            if (message instanceof RequestWorkerMsgType) {
                switch ((RequestWorkerMsgType)((Object)message)) {
                    case PROCESS_REQUEST: {
                        ++this.tryCount;
                        if (this.tryCount == 1) {
                            this.sender = this.getSender();
                            AsyncHttpClient.BoundRequestBuilder request = this.createRequest();
                            this.responseFuture = request.execute((AsyncHandler)new HttpAsyncHandler(this));
                            this.timeoutDuration = Duration.create((long)this.actorMaxOperationTimeoutSec, (TimeUnit)TimeUnit.SECONDS);
                            this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                            break;
                        }
                        HttpWorker.getLogger().error("duplicated PROCESS_REQUEST msg. ignore...");
                        break;
                    }
                    case CANCEL: {
                        HttpWorker.getLogger().info("Request was CANCELLED.................{}", (Object)this.requestUrl);
                        this.cancelCancellable();
                        if (this.sender == null) {
                            this.sender = this.getSender();
                        }
                        this.reply(null, true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1, null);
                        break;
                    }
                    case PROCESS_ON_EXCEPTION: {
                        String errorSummary = PcErrorMsgUtils.replaceErrorMsg(this.cause.toString());
                        String stackTrace = PcStringUtils.printStackTrace(this.cause);
                        this.cancelCancellable();
                        this.reply(null, true, errorSummary, stackTrace, "NA", -1, null);
                        break;
                    }
                    case PROCESS_ON_TIMEOUT: {
                        HttpWorker.getLogger().error("PROCESS_ON_TIMEOUT.................{}", (Object)this.requestUrl);
                        this.cancelCancellable();
                        String errorMsg = String.format("HttpWorker Timedout after %d SEC (no response but no exception catched). Check URL: may be very slow or stuck.", this.actorMaxOperationTimeoutSec);
                        this.reply(null, true, errorMsg, errorMsg, "NA", -1, null);
                        break;
                    }
                    default: {
                        this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for url " + this.requestUrl);
                        this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
                        break;
                    }
                }
            } else {
                this.unhandled(message);
                this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for url " + this.requestUrl);
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
        }
        catch (Exception e) {
            this.cause = e;
            this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
        }
    }

    public void cancelCancellable() {
        if (this.timeoutMessageCancellable != null) {
            this.timeoutMessageCancellable.cancel();
        }
    }

    private void reply(String response, boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt, Map<String, List<String>> responseHeaders) {
        if (!this.sentReply) {
            this.sentReply = true;
            ResponseOnSingeRequest res = new ResponseOnSingeRequest(response, error, errorMessage, stackTrace, statusCode, statusCodeInt, PcDateUtils.getNowDateTimeStrStandard(), responseHeaders);
            if (!this.getContext().system().deadLetters().equals((Object)this.sender)) {
                this.sender.tell((Object)res, this.getSelf());
            }
            if (this.getContext() != null) {
                this.getContext().stop(this.getSelf());
            }
        }
    }

    public ResponseOnSingeRequest onComplete(Response response) {
        this.cancelCancellable();
        try {
            LinkedHashMap<String, List<String>> responseHeaders = null;
            if (this.responseHeaderMeta != null) {
                responseHeaders = new LinkedHashMap<String, List<String>>();
                if (this.responseHeaderMeta.isGetAll()) {
                    for (Map.Entry header : response.getHeaders()) {
                        responseHeaders.put(((String)header.getKey()).toLowerCase(Locale.ROOT), (List<String>)header.getValue());
                    }
                } else {
                    for (String key : this.responseHeaderMeta.getKeys()) {
                        if (!response.getHeaders().containsKey((Object)key)) continue;
                        responseHeaders.put(key.toLowerCase(Locale.ROOT), response.getHeaders().get((Object)key));
                    }
                }
            }
            int statusCodeInt = response.getStatusCode();
            String statusCode = statusCodeInt + " " + response.getStatusText();
            String charset = ParallecGlobalConfig.httpResponseBodyCharsetUsesResponseContentType ? AsyncHttpProviderUtils.parseCharset((String)response.getContentType()) : ParallecGlobalConfig.httpResponseBodyDefaultCharset;
            this.reply(response.getResponseBody(charset), false, null, null, statusCode, statusCodeInt, responseHeaders);
        }
        catch (IOException e) {
            HttpWorker.getLogger().error("fail response.getResponseBody " + e);
        }
        return null;
    }

    public void onThrowable(Throwable cause) {
        this.cause = cause;
        this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        HttpWorker.logger = logger;
    }

    static class HttpAsyncHandler
    extends AsyncCompletionHandler<ResponseOnSingeRequest> {
        private final HttpWorker httpWorker;

        public HttpAsyncHandler(HttpWorker httpWorker) {
            this.httpWorker = httpWorker;
        }

        public ResponseOnSingeRequest onCompleted(Response response) throws Exception {
            ResponseOnSingeRequest myResponse = null;
            this.httpWorker.onComplete(response);
            return myResponse;
        }

        public void onThrowable(Throwable t) {
            this.httpWorker.onThrowable(t);
        }
    }
}

