/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.commander.workflow;

import io.parallec.core.ParallelTask;
import io.parallec.core.actor.message.NodeReqResponse;
import io.parallec.core.bean.HttpMeta;
import io.parallec.core.bean.TargetHostMeta;
import io.parallec.core.util.PcDateUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDataProvider {
    private static Logger logger = LoggerFactory.getLogger(InternalDataProvider.class);
    private static final InternalDataProvider instance = new InternalDataProvider();

    public static InternalDataProvider getInstance() {
        return instance;
    }

    private InternalDataProvider() {
    }

    public void genNodeDataMap(ParallelTask task) {
        TargetHostMeta targetHostMeta = task.getTargetHostMeta();
        HttpMeta httpMeta = task.getHttpMeta();
        String entityBody = httpMeta.getEntityBody();
        String requestContent = HttpMeta.replaceDefaultFullRequestContent(entityBody);
        Map<String, NodeReqResponse> parallelTaskResult = task.getParallelTaskResult();
        for (String fqdn : targetHostMeta.getHosts()) {
            NodeReqResponse nodeReqResponse = new NodeReqResponse(fqdn);
            nodeReqResponse.setDefaultReqestContent(requestContent);
            parallelTaskResult.put(fqdn, nodeReqResponse);
        }
    }

    public void filterUnsafeOrUnnecessaryRequest(Map<String, NodeReqResponse> nodeDataMapValidSource, Map<String, NodeReqResponse> nodeDataMapValidSafe) {
        for (Map.Entry<String, NodeReqResponse> entry : nodeDataMapValidSource.entrySet()) {
            Boolean willExecute;
            String hostName = entry.getKey();
            NodeReqResponse nrr = entry.getValue();
            Map<String, String> map = nrr.getRequestParameters();
            if (map.containsKey("NODE_REQUEST_WILL_EXECUTE") && !(willExecute = Boolean.valueOf(Boolean.parseBoolean(map.get("NODE_REQUEST_WILL_EXECUTE")))).booleanValue()) {
                logger.info("NOT_EXECUTE_COMMAND  on target: " + hostName + " at " + PcDateUtils.getNowDateTimeStrStandard());
                continue;
            }
            nodeDataMapValidSafe.put(hostName, nrr);
        }
    }
}

