/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.task;

import io.parallec.core.ParallelTask;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.task.ParallelTaskManager;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityAwareTaskScheduler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CapacityAwareTaskScheduler.class);

    @Override
    public void run() {
        try {
            Queue<ParallelTask> waitQ = ParallelTaskManager.getInstance().getWaitQ();
            logger.debug("TASK_WAIT_Q: Current waitQ has task count: {} in Thread scheduler", (Object)waitQ.size());
            final ParallelTask task = waitQ.peek();
            if (task != null) {
                int totalUsedCapacityBefore = ParallelTaskManager.getInstance().getTotalUsedCapacity();
                int capacityThisTask = task.capacityUsed();
                int capacityRemain = ParallecGlobalConfig.maxCapacity - totalUsedCapacityBefore;
                int totalUsedCapacityNew = totalUsedCapacityBefore + capacityThisTask;
                logger.info("TASK_WAIT_Q: Exists Task in WaitQ with head of queue task id {}....Current used capacity {}, and remaining capacity is {}", new Object[]{task.getTaskId(), totalUsedCapacityBefore, capacityRemain});
                if (totalUsedCapacityNew <= ParallecGlobalConfig.maxCapacity) {
                    logger.info("TASK_WAIT_Q: Sufficent capacity. Execute new task from wait queue. Task capacity {} with total used capacity is now {}, capacityRemain will be {}", new Object[]{capacityThisTask, totalUsedCapacityNew, ParallecGlobalConfig.maxCapacity - totalUsedCapacityNew});
                    waitQ.poll();
                    Runnable taskRunnable = new Runnable(){

                        @Override
                        public void run() {
                            ParallelTaskManager.getInstance().generateUpdateExecuteTask(task);
                        }
                    };
                    new Thread(taskRunnable).start();
                } else {
                    logger.info("TASK_WAIT_Q: Skip execution new task. Insufficent capacity. Head of queue task needs capacity {}. However capacityRemain is only {}.", (Object)capacityThisTask, (Object)capacityRemain);
                }
            }
        }
        catch (Exception e) {
            logger.error("TASK_WAIT_Q: fail in EvalTaskInWaitQRunner ", (Throwable)e);
        }
    }
}

