/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.taskbuilder.targethosts;

import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.TargetHostsLoadException;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcFileNetworkIoUtils;
import io.parallec.core.util.PcStringUtils;
import io.parallec.core.util.PcTargetHostsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHostsBuilderHelperCms {
    static Logger logger = LoggerFactory.getLogger(TargetHostsBuilderHelperCms.class);
    public static final boolean ADD_QUOTE = true;

    static List<String> getFQDNValueListCMS(JSONObject jObj, String projectionStr) throws JSONException {
        ArrayList<String> labelList = new ArrayList<String>();
        if (!jObj.has("result")) {
            logger.error("!!CMS_ERROR! result key is not in jOBJ in getFQDNValueListCMS!!: \njObj:" + PcStringUtils.renderJson(jObj));
            return labelList;
        }
        JSONArray jArr = (JSONArray)jObj.get("result");
        if (jArr == null || jArr.length() == 0) {
            return labelList;
        }
        for (int i = 0; i < jArr.length(); ++i) {
            String label;
            JSONObject agentObj = jArr.getJSONObject(i);
            if (!agentObj.has(projectionStr) || (label = (String)agentObj.get(projectionStr)) == null || label.trim().isEmpty()) continue;
            labelList.add(label);
        }
        return labelList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONObject readJsonFromUrlWithCmsHeader(String url, String token) throws MalformedURLException, IOException, JSONException {
        InputStream is = null;
        JSONObject jObj = new JSONObject();
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("GET");
            if (token != null) {
                con.setRequestProperty("Authorization", token);
            }
            con.setConnectTimeout(ParallecGlobalConfig.urlConnectionConnectTimeoutMillis);
            con.setReadTimeout(ParallecGlobalConfig.urlConnectionReadTimeoutMillis);
            is = con.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = PcFileNetworkIoUtils.readAll(rd);
            jObj = new JSONObject(jsonText);
            rd.close();
        }
        catch (Exception t) {
            logger.error("readJsonFromUrl() exception: " + t.getLocalizedMessage() + PcDateUtils.getNowDateTimeStrStandard());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return jObj;
    }

    public List<String> getNodeListCompleteURLForCMS(String url, String projectionStr, String token) {
        ArrayList<String> nodes = new ArrayList<String>();
        try {
            int indexNextUrlStartPos = url.indexOf("/repositories/");
            String cmsQueryUrlPrefix = url.substring(0, indexNextUrlStartPos);
            JSONObject jsonObject = TargetHostsBuilderHelperCms.readJsonFromUrlWithCmsHeader(url, token);
            nodes.addAll(TargetHostsBuilderHelperCms.getFQDNValueListCMS(jsonObject, projectionStr));
            JSONObject jsonObjectNext = jsonObject;
            Boolean hasMore = false;
            String hasMoreNextUrl = null;
            String KEY_HAS_MORE = "hasmore";
            String KEY_NEXT_PARENT = "next";
            String KEY_NEXT_URL = "url";
            do {
                hasMore = false;
                hasMoreNextUrl = null;
                if (!jsonObjectNext.has(KEY_HAS_MORE)) continue;
                hasMore = jsonObjectNext.getBoolean(KEY_HAS_MORE);
                if (jsonObjectNext.has(KEY_NEXT_PARENT) && jsonObjectNext.getJSONObject(KEY_NEXT_PARENT).has(KEY_NEXT_URL)) {
                    hasMoreNextUrl = jsonObjectNext.getJSONObject(KEY_NEXT_PARENT).getString(KEY_NEXT_URL);
                }
                if (hasMoreNextUrl == null) continue;
                String nextUrlComplete = cmsQueryUrlPrefix + hasMoreNextUrl;
                jsonObjectNext = TargetHostsBuilderHelperCms.readJsonFromUrlWithCmsHeader(nextUrlComplete, token);
                nodes.addAll(TargetHostsBuilderHelperCms.getFQDNValueListCMS(jsonObjectNext, projectionStr));
                logger.info("CMS query: hasMore==true. Found next round in query with URL:" + nextUrlComplete);
            } while (hasMore.booleanValue());
            int removedDuplicatedNodeCount = PcTargetHostsUtils.removeDuplicateNodeList(nodes);
            if (removedDuplicatedNodeCount > 0) {
                logger.info(" Removed duplicated node #: " + removedDuplicatedNodeCount);
            }
            logger.info("List size: " + nodes.size());
        }
        catch (Exception e) {
            throw new TargetHostsLoadException("error when reading  " + url, e);
        }
        return nodes;
    }
}

