/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcDateUtils {
    private static Logger logger = LoggerFactory.getLogger(PcDateUtils.class);

    public static String getDateTimeStr(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        return sdf.format(d);
    }

    public static String getDateTimeStrStandard(Date d) {
        if (d == null) {
            return "";
        }
        if (d.getTime() == 0L) {
            return "Never";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSSZ");
        return sdf.format(d);
    }

    public static String getDateTimeStrConcise(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
        return sdf.format(d);
    }

    public static String getDateTimeStrConciseNoZone(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(d);
    }

    public static Date getDateFromConciseStr(String str) {
        Date d = null;
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
            d = sdf.parse(str);
        }
        catch (Exception ex) {
            logger.error(ex + "Exception while converting string to date : " + str);
        }
        return d;
    }

    public static String getNowDateTimeStr() {
        return PcDateUtils.getDateTimeStr(new Date());
    }

    public static String getNowDateTimeStrStandard() {
        return PcDateUtils.getDateTimeStrStandard(new Date());
    }

    public static String getNowDateTimeStrConcise() {
        return PcDateUtils.getDateTimeStrConcise(new Date());
    }

    public static String getNowDateTimeStrConciseNoZone() {
        return PcDateUtils.getDateTimeStrConciseNoZone(new Date());
    }
}

