/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import io.parallec.core.HostsSourceType;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.taskbuilder.targethosts.TargetHostsBuilder;
import io.parallec.core.util.PcDateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcFileNetworkIoUtils {
    private static Logger logger = LoggerFactory.getLogger(PcFileNetworkIoUtils.class);

    public static InputStream readFileToInputStream(String filePath) throws FileNotFoundException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            logger.info("Completed read file for input stream  Path: " + filePath + " at " + PcDateUtils.getNowDateTimeStr());
        }
        catch (Exception e) {
            logger.error("Error read file." + e);
        }
        return is;
    }

    public static boolean isFileExist(String filePath) {
        File f = new File(filePath);
        return f.exists() && !f.isDirectory();
    }

    public static String readFileContentToString(String filePath) throws IOException {
        String content = "";
        content = Files.toString((File)new File(filePath), (Charset)Charsets.UTF_8);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromUrlGeneric(String url) throws IOException {
        InputStream is = null;
        URL urlObj = null;
        String responseString = "NA";
        try {
            urlObj = new URL(url);
            URLConnection con = urlObj.openConnection();
            con.setConnectTimeout(ParallecGlobalConfig.urlConnectionConnectTimeoutMillis);
            con.setReadTimeout(ParallecGlobalConfig.urlConnectionReadTimeoutMillis);
            is = con.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            responseString = PcFileNetworkIoUtils.readAll(rd);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return responseString;
    }

    public static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static List<String> getListFromLineByLineText(String sourcePath, HostsSourceType sourceType) {
        TargetHostsBuilder thb = new TargetHostsBuilder();
        ArrayList<String> list = new ArrayList();
        try {
            list = thb.setTargetHostsFromLineByLineText(sourcePath, sourceType);
        }
        catch (Exception e) {
            logger.error("error getListFromLineByLineText " + e);
        }
        return list;
    }
}

