/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.exceptions;

import io.pinecone.exceptions.FailedRequestInfo;
import io.pinecone.exceptions.PineconeAlreadyExistsException;
import io.pinecone.exceptions.PineconeAuthorizationException;
import io.pinecone.exceptions.PineconeBadRequestException;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeForbiddenException;
import io.pinecone.exceptions.PineconeInternalServerException;
import io.pinecone.exceptions.PineconeNotFoundException;
import io.pinecone.exceptions.PineconeUnmappedHttpException;

public class HttpErrorMapper {
    public static void mapHttpStatusError(FailedRequestInfo failedRequestInfo) throws PineconeException {
        int statusCode = failedRequestInfo.getStatus();
        switch (statusCode) {
            case 400: {
                throw new PineconeBadRequestException(failedRequestInfo.getMessage());
            }
            case 401: {
                throw new PineconeAuthorizationException(failedRequestInfo.getMessage());
            }
            case 403: {
                throw new PineconeForbiddenException(failedRequestInfo.getMessage());
            }
            case 404: {
                throw new PineconeNotFoundException(failedRequestInfo.getMessage());
            }
            case 409: {
                throw new PineconeAlreadyExistsException(failedRequestInfo.getMessage());
            }
            case 500: {
                throw new PineconeInternalServerException(failedRequestInfo.getMessage());
            }
        }
        throw new PineconeUnmappedHttpException(failedRequestInfo.getMessage());
    }
}

