/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CollectionList;
import org.openapitools.client.model.CollectionModel;
import org.openapitools.client.model.ConfigureIndexRequest;
import org.openapitools.client.model.CreateCollectionRequest;
import org.openapitools.client.model.CreateIndexRequest;
import org.openapitools.client.model.IndexList;
import org.openapitools.client.model.IndexModel;

public class ManageIndexesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ManageIndexesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManageIndexesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call configureIndexCall(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ConfigureIndexRequest localVarPostBody = configureIndexRequest;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call configureIndexValidateBeforeCall(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling configureIndex(Async)");
        }
        if (configureIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'configureIndexRequest' when calling configureIndex(Async)");
        }
        return this.configureIndexCall(indexName, configureIndexRequest, _callback);
    }

    public IndexModel configureIndex(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.configureIndexWithHttpInfo(indexName, configureIndexRequest);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> configureIndexWithHttpInfo(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        Call localVarCall = this.configureIndexValidateBeforeCall(indexName, configureIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call configureIndexAsync(String indexName, ConfigureIndexRequest configureIndexRequest, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.configureIndexValidateBeforeCall(indexName, configureIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createCollectionCall(CreateCollectionRequest createCollectionRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCollectionRequest localVarPostBody = createCollectionRequest;
        String localVarPath = "/collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCollectionValidateBeforeCall(CreateCollectionRequest createCollectionRequest, ApiCallback _callback) throws ApiException {
        if (createCollectionRequest == null) {
            throw new ApiException("Missing the required parameter 'createCollectionRequest' when calling createCollection(Async)");
        }
        return this.createCollectionCall(createCollectionRequest, _callback);
    }

    public CollectionModel createCollection(CreateCollectionRequest createCollectionRequest) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = this.createCollectionWithHttpInfo(createCollectionRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CollectionModel> createCollectionWithHttpInfo(CreateCollectionRequest createCollectionRequest) throws ApiException {
        Call localVarCall = this.createCollectionValidateBeforeCall(createCollectionRequest, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCollectionAsync(CreateCollectionRequest createCollectionRequest, ApiCallback<CollectionModel> _callback) throws ApiException {
        Call localVarCall = this.createCollectionValidateBeforeCall(createCollectionRequest, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIndexCall(CreateIndexRequest createIndexRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateIndexRequest localVarPostBody = createIndexRequest;
        String localVarPath = "/indexes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIndexValidateBeforeCall(CreateIndexRequest createIndexRequest, ApiCallback _callback) throws ApiException {
        if (createIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'createIndexRequest' when calling createIndex(Async)");
        }
        return this.createIndexCall(createIndexRequest, _callback);
    }

    public IndexModel createIndex(CreateIndexRequest createIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.createIndexWithHttpInfo(createIndexRequest);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> createIndexWithHttpInfo(CreateIndexRequest createIndexRequest) throws ApiException {
        Call localVarCall = this.createIndexValidateBeforeCall(createIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIndexAsync(CreateIndexRequest createIndexRequest, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.createIndexValidateBeforeCall(createIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionCall(String collectionName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections/{collection_name}".replace("{collection_name}", this.localVarApiClient.escapeString(collectionName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionValidateBeforeCall(String collectionName, ApiCallback _callback) throws ApiException {
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling deleteCollection(Async)");
        }
        return this.deleteCollectionCall(collectionName, _callback);
    }

    public String deleteCollection(String collectionName) throws ApiException {
        ApiResponse<String> localVarResp = this.deleteCollectionWithHttpInfo(collectionName);
        return localVarResp.getData();
    }

    public ApiResponse<String> deleteCollectionWithHttpInfo(String collectionName) throws ApiException {
        Call localVarCall = this.deleteCollectionValidateBeforeCall(collectionName, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionAsync(String collectionName, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionValidateBeforeCall(collectionName, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIndexCall(String indexName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIndexValidateBeforeCall(String indexName, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling deleteIndex(Async)");
        }
        return this.deleteIndexCall(indexName, _callback);
    }

    public void deleteIndex(String indexName) throws ApiException {
        this.deleteIndexWithHttpInfo(indexName);
    }

    public ApiResponse<Void> deleteIndexWithHttpInfo(String indexName) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIndexAsync(String indexName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIndexValidateBeforeCall(indexName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call describeCollectionCall(String collectionName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections/{collection_name}".replace("{collection_name}", this.localVarApiClient.escapeString(collectionName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeCollectionValidateBeforeCall(String collectionName, ApiCallback _callback) throws ApiException {
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling describeCollection(Async)");
        }
        return this.describeCollectionCall(collectionName, _callback);
    }

    public CollectionModel describeCollection(String collectionName) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = this.describeCollectionWithHttpInfo(collectionName);
        return localVarResp.getData();
    }

    public ApiResponse<CollectionModel> describeCollectionWithHttpInfo(String collectionName) throws ApiException {
        Call localVarCall = this.describeCollectionValidateBeforeCall(collectionName, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeCollectionAsync(String collectionName, ApiCallback<CollectionModel> _callback) throws ApiException {
        Call localVarCall = this.describeCollectionValidateBeforeCall(collectionName, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call describeIndexCall(String indexName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes/{index_name}".replace("{index_name}", this.localVarApiClient.escapeString(indexName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeIndexValidateBeforeCall(String indexName, ApiCallback _callback) throws ApiException {
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling describeIndex(Async)");
        }
        return this.describeIndexCall(indexName, _callback);
    }

    public IndexModel describeIndex(String indexName) throws ApiException {
        ApiResponse<IndexModel> localVarResp = this.describeIndexWithHttpInfo(indexName);
        return localVarResp.getData();
    }

    public ApiResponse<IndexModel> describeIndexWithHttpInfo(String indexName) throws ApiException {
        Call localVarCall = this.describeIndexValidateBeforeCall(indexName, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call describeIndexAsync(String indexName, ApiCallback<IndexModel> _callback) throws ApiException {
        Call localVarCall = this.describeIndexValidateBeforeCall(indexName, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCollectionsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCollectionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listCollectionsCall(_callback);
    }

    public CollectionList listCollections() throws ApiException {
        ApiResponse<CollectionList> localVarResp = this.listCollectionsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CollectionList> listCollectionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCollectionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCollectionsAsync(ApiCallback<CollectionList> _callback) throws ApiException {
        Call localVarCall = this.listCollectionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIndexesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://api.pinecone.io"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/indexes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIndexesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listIndexesCall(_callback);
    }

    public IndexList listIndexes() throws ApiException {
        ApiResponse<IndexList> localVarResp = this.listIndexesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<IndexList> listIndexesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listIndexesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIndexesAsync(ApiCallback<IndexList> _callback) throws ApiException {
        Call localVarCall = this.listIndexesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

