/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Cookies;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientFormEncoder;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.RedirectClientException;
import reactor.netty.http.client.WebsocketClientOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

class HttpClientOperations
extends HttpOperations<NettyInbound, NettyOutbound>
implements HttpClientResponse,
HttpClientRequest {
    final Supplier<String>[] redirectedFrom;
    final boolean isSecure;
    final HttpRequest nettyRequest;
    final HttpHeaders requestHeaders;
    final ClientCookieEncoder cookieEncoder;
    final ClientCookieDecoder cookieDecoder;
    volatile ResponseState responseState;
    boolean started;
    boolean redirectable;
    static final int MAX_REDIRECTS = 50;
    static final Supplier<String>[] EMPTY_REDIRECTIONS = new Supplier[0];
    static final Logger log = Loggers.getLogger(HttpClientOperations.class);
    static final AttributeKey<Supplier<String>[]> REDIRECT_ATTR_KEY = AttributeKey.newInstance((String)"httpRedirects");

    HttpClientOperations(HttpClientOperations replaced) {
        super(replaced);
        this.started = replaced.started;
        this.redirectedFrom = replaced.redirectedFrom;
        this.isSecure = replaced.isSecure;
        this.nettyRequest = replaced.nettyRequest;
        this.responseState = replaced.responseState;
        this.redirectable = replaced.redirectable;
        this.requestHeaders = replaced.requestHeaders;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieDecoder = replaced.cookieDecoder;
    }

    HttpClientOperations(Connection c, ConnectionObserver listener, ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        super(c, listener);
        this.isSecure = c.channel().pipeline().get("reactor.left.sslHandler") != null;
        Supplier[] redirects = (Supplier[])c.channel().attr(REDIRECT_ATTR_KEY).get();
        this.redirectedFrom = redirects == null ? EMPTY_REDIRECTIONS : redirects;
        this.nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.requestHeaders = this.nettyRequest.headers();
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(ChannelHandler handler) {
        super.addHandlerLast(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(String name, ChannelHandler handler) {
        super.addHandlerLast(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(ChannelHandler handler) {
        super.addHandlerFirst(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(String name, ChannelHandler handler) {
        super.addHandlerFirst(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(ChannelHandler handler) {
        super.addHandler(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations replaceHandler(String name, ChannelHandler handler) {
        super.replaceHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations removeHandler(String name) {
        super.removeHandler(name);
        return this;
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public InetSocketAddress address() {
        return (InetSocketAddress)this.channel().remoteAddress();
    }

    public void chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest) != chunked) {
            this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyRequest, (boolean)chunked);
        }
    }

    @Override
    public HttpClientOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        ResponseState responseState = this.responseState;
        if (responseState != null && responseState.cookieHolder != null) {
            return responseState.cookieHolder.getCachedCookies();
        }
        return Collections.emptyMap();
    }

    public void followRedirect(boolean redirectable) {
        this.redirectable = redirectable;
    }

    @Override
    protected void onInboundCancel() {
        if (this.isInboundDisposed()) {
            return;
        }
        this.channel().close();
    }

    @Override
    protected void onInboundClose() {
        if (this.isInboundCancelled() || this.isInboundDisposed()) {
            return;
        }
        this.listener().onStateChange(this, HttpClientState.RESPONSE_INCOMPLETE);
        if (this.responseState == null) {
            this.listener().onUncaughtException(this, PrematureCloseException.BEFORE_RESPONSE);
            return;
        }
        super.onInboundError(PrematureCloseException.DURING_RESPONSE);
    }

    @Override
    public NettyOutbound sendObject(Publisher<?> dataStream) {
        if (!(HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest) || HttpUtil.isContentLengthSet((HttpMessage)this.nettyRequest) || this.method().equals((Object)HttpMethod.HEAD) || this.hasSentHeaders())) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyRequest, (boolean)true);
        }
        return super.sendObject(dataStream);
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        String host = this.requestHeaders.get((CharSequence)HttpHeaderNames.HOST);
        this.requestHeaders.set(headers);
        this.requestHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.redirectable && this.redirectedFrom.length <= 50;
    }

    @Override
    public boolean isKeepAlive() {
        ResponseState rs = this.responseState;
        if (rs != null) {
            return HttpUtil.isKeepAlive((HttpMessage)rs.response);
        }
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        ChannelOperations<?, ?> ops = HttpClientOperations.get(this.channel());
        return ops != null && ops.getClass().equals(WebsocketClientOperations.class);
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public final HttpClientOperations onDispose(Disposable onDispose) {
        super.onDispose(onDispose);
        return this;
    }

    @Override
    public String[] redirectedFrom() {
        Supplier<String>[] redirectedFrom = this.redirectedFrom;
        String[] dest = new String[redirectedFrom.length];
        for (int i = 0; i < redirectedFrom.length; ++i) {
            dest[i] = redirectedFrom[i].get();
        }
        return dest;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.nettyRequest.headers();
    }

    @Override
    public HttpHeaders responseHeaders() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.headers;
        }
        throw new IllegalStateException("Response headers cannot be accessed without server response");
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (Objects.equals(this.method(), HttpMethod.GET) || Objects.equals(this.method(), HttpMethod.HEAD)) {
            ByteBufAllocator alloc = this.channel().alloc();
            return this.then((Publisher)Flux.from(source).doOnNext(ByteBuf::retain).collect(() -> ((ByteBufAllocator)alloc).buffer(), ByteBuf::writeBytes).flatMapMany(agg -> {
                if (!(this.hasSentHeaders() || HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) || HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()))) {
                    this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, agg.readableBytes());
                }
                return super.send((Publisher)Mono.just((Object)agg)).then();
            }));
        }
        return super.send(source);
    }

    final URI websocketUri() {
        URI uri;
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    @Override
    public HttpResponseStatus status() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return HttpResponseStatus.valueOf((int)responseState.response.status().code());
        }
        throw new IllegalStateException("Trying to access status() while missing response");
    }

    @Override
    public final String uri() {
        return this.nettyRequest.uri();
    }

    @Override
    public final HttpVersion version() {
        HttpVersion version = this.nettyRequest.protocolVersion();
        if (version.equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpVersion.HTTP_1_0;
        }
        if (version.equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void preSendHeadersAndStatus() {
    }

    @Override
    protected void onOutboundComplete() {
        if (this.isWebsocket() || this.isInboundCancelled()) {
            return;
        }
        if (this.markSentHeaderAndBody()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            this.channel().writeAndFlush((Object)this.newFullEmptyBodyMessage());
        } else if (this.markSentBody()) {
            this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        this.listener().onStateChange(this, HttpClientState.REQUEST_SENT);
        this.channel().read();
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.isPersistent() && this.responseState == null) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.listener().onUncaughtException(this, err);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        super.onOutboundError(err);
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (response.decoderResult().isFailure()) {
                this.onInboundError(response.decoderResult().cause());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations cannot proceed more than one response {}"), new Object[]{response.headers().toString()});
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.started = true;
            this.setNettyResponse(response);
            if (!this.isKeepAlive()) {
                this.markPersistent(false);
            }
            if (this.isInboundCancelled()) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received response (auto-read:{}) : {}"), new Object[]{this.channel().config().isAutoRead(), this.responseHeaders().entries().toString()});
            }
            if (this.notRedirected(response)) {
                this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
            }
            if (msg instanceof FullHttpResponse) {
                super.onInboundNext(ctx, msg);
                this.terminate();
            }
            return;
        }
        if (msg instanceof LastHttpContent) {
            if (!this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect end delimiter (previously used connection?)"));
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received last HTTP packet"));
            }
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            this.channel().config().setAutoRead(true);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        if (!this.started) {
            if (log.isDebugEnabled()) {
                if (msg instanceof ByteBufHolder) {
                    msg = ((ByteBufHolder)msg).content();
                }
                log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect chunk {} (previously used connection?)"), new Object[]{msg});
            }
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.onInboundNext(ctx, msg);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyRequest;
    }

    final boolean notRedirected(HttpResponse response) {
        int code = response.status().code();
        if ((code == 301 || code == 302) && this.isFollowRedirect()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received redirect location: {}"), new Object[]{response.headers().entries().toString()});
            }
            this.listener().onUncaughtException(this, new RedirectClientException(response));
            return false;
        }
        return true;
    }

    @Override
    protected HttpMessage newFullEmptyBodyMessage() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.version(), this.method(), this.uri());
        request.headers().set(this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0));
        return request;
    }

    final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    final Mono<Void> send() {
        if (this.markSentHeaderAndBody()) {
            HttpMessage request = this.newFullEmptyBodyMessage();
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)request));
        }
        return Mono.empty();
    }

    final void setNettyResponse(HttpResponse nettyResponse) {
        ResponseState state = this.responseState;
        if (state == null) {
            this.responseState = new ResponseState(nettyResponse, nettyResponse.headers(), this.cookieDecoder);
        }
    }

    final void withWebsocketSupport(String protocols, int maxFramePayloadLength) {
        URI url = this.websocketUri();
        if (this.markSentHeaders()) {
            this.addHandlerFirst("reactor.left.httpAggregator", (ChannelHandler)new HttpObjectAggregator(8192));
            WebsocketClientOperations ops = new WebsocketClientOperations(url, protocols, maxFramePayloadLength, this);
            if (!this.rebind(ops)) {
                log.error(ReactorNetty.format(this.channel(), "Error while rebinding websocket in channel attribute: " + HttpClientOperations.get(this.channel()) + " to " + ops));
            }
        }
    }

    static final class PrematureCloseException
    extends IOException {
        static final PrematureCloseException BEFORE_RESPONSE = new PrematureCloseException("Connection prematurely closed BEFORE response");
        static final PrematureCloseException DURING_RESPONSE = new PrematureCloseException("Connection prematurely closed DURING response");

        PrematureCloseException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class SendForm
    extends Mono<Void> {
        static final HttpDataFactory DEFAULT_FACTORY = new DefaultHttpDataFactory(16384L);
        final HttpClientOperations parent;
        final BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback;
        final Consumer<Flux<Long>> progressCallback;

        SendForm(HttpClientOperations parent, BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progressCallback) {
            this.parent = parent;
            this.formCallback = formCallback;
            this.progressCallback = progressCallback;
        }

        public void subscribe(CoreSubscriber<? super Void> s) {
            if (this.parent.channel().eventLoop().inEventLoop()) {
                this._subscribe(s);
            } else {
                this.parent.channel().eventLoop().execute(() -> this._subscribe(s));
            }
        }

        void _subscribe(CoreSubscriber<? super Void> s) {
            if (!this.parent.markSentHeaders()) {
                Operators.error(s, (Throwable)new IllegalStateException("headers have already been sent"));
                return;
            }
            HttpDataFactory df = DEFAULT_FACTORY;
            try {
                HttpClientFormEncoder encoder = new HttpClientFormEncoder(df, this.parent.nettyRequest, false, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
                this.formCallback.accept(this.parent, encoder);
                encoder = encoder.applyChanges(this.parent.nettyRequest);
                df = encoder.newFactory;
                if (!encoder.isMultipart()) {
                    this.parent.chunkedTransfer(false);
                }
                this.parent.addHandlerFirst("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)this.parent.nettyRequest);
                HttpRequest r = encoder.finalizeRequest();
                if (!chunked) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)r, (boolean)false);
                    HttpUtil.setContentLength((HttpMessage)r, (long)encoder.length());
                }
                ChannelFuture f = this.parent.channel().writeAndFlush((Object)r);
                Flux tail = encoder.progressFlux.onBackpressureLatest();
                if (encoder.cleanOnTerminate) {
                    tail = tail.doOnCancel((Runnable)encoder).doAfterTerminate((Runnable)encoder);
                }
                if (encoder.isChunked()) {
                    if (this.progressCallback != null) {
                        this.progressCallback.accept((Flux<Long>)tail);
                    }
                    this.parent.channel().writeAndFlush((Object)encoder);
                } else if (this.progressCallback != null) {
                    this.progressCallback.accept((Flux<Long>)FutureMono.from(f).cast(Long.class).switchIfEmpty(Mono.just((Object)encoder.length())).flux());
                }
                Operators.complete(s);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                df.cleanRequestHttpData(this.parent.nettyRequest);
                Operators.error(s, (Throwable)Exceptions.unwrap((Throwable)e));
            }
        }
    }

    static final class ResponseState {
        final HttpResponse response;
        final HttpHeaders headers;
        final Cookies cookieHolder;

        ResponseState(HttpResponse response, HttpHeaders headers, ClientCookieDecoder decoder) {
            this.response = response;
            this.headers = headers;
            this.cookieHolder = Cookies.newClientResponseHolder(headers, decoder);
        }
    }
}

