/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import java.util.function.Supplier;

public abstract class HttpDecoderSpec<T extends HttpDecoderSpec<T>>
implements Supplier<T> {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    protected int maxInitialLineLength = 4096;
    protected int maxHeaderSize = 8192;
    protected int maxChunkSize = 8192;
    protected boolean validateHeaders = true;
    protected int initialBufferSize = 128;

    public T maxInitialLineLength(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be strictly positive");
        }
        this.maxInitialLineLength = value;
        return (T)((HttpDecoderSpec)this.get());
    }

    public int maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public T maxHeaderSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be strictly positive");
        }
        this.maxHeaderSize = value;
        return (T)((HttpDecoderSpec)this.get());
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public T maxChunkSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be strictly positive");
        }
        this.maxChunkSize = value;
        return (T)((HttpDecoderSpec)this.get());
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public T validateHeaders(boolean validate) {
        this.validateHeaders = validate;
        return (T)((HttpDecoderSpec)this.get());
    }

    public boolean validateHeaders() {
        return this.validateHeaders;
    }

    public T initialBufferSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("initialBufferSize must be strictly positive");
        }
        this.initialBufferSize = value;
        return (T)((HttpDecoderSpec)this.get());
    }

    public int initialBufferSize() {
        return this.initialBufferSize;
    }
}

