/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter.common;

import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.TreeMap;

public class TextFormat {
    public static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";
    public static final String CONTENT_TYPE_OPENMETRICS_100 = "application/openmetrics-text; version=1.0.0; charset=utf-8";

    public static String chooseContentType(String acceptHeader) {
        if (acceptHeader == null) {
            return CONTENT_TYPE_004;
        }
        for (String accepts : acceptHeader.split(",")) {
            if (!"application/openmetrics-text".equals(accepts.split(";")[0].trim())) continue;
            return CONTENT_TYPE_OPENMETRICS_100;
        }
        return CONTENT_TYPE_004;
    }

    public static void writeFormat(String contentType, Writer writer, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        if (CONTENT_TYPE_004.equals(contentType)) {
            TextFormat.write004(writer, mfs);
            return;
        }
        if (CONTENT_TYPE_OPENMETRICS_100.equals(contentType)) {
            TextFormat.writeOpenMetrics100(writer, mfs);
            return;
        }
        throw new IllegalArgumentException("Unknown contentType " + contentType);
    }

    public static void write004(Writer writer, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        TreeMap<String, Collector.MetricFamilySamples> omFamilies = new TreeMap<String, Collector.MetricFamilySamples>();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            String name = metricFamilySamples.name;
            writer.write("# HELP ");
            writer.write(name);
            if (metricFamilySamples.type == Collector.Type.COUNTER) {
                writer.write("_total");
            }
            if (metricFamilySamples.type == Collector.Type.INFO) {
                writer.write("_info");
            }
            writer.write(32);
            TextFormat.writeEscapedHelp(writer, metricFamilySamples.help);
            writer.write(10);
            writer.write("# TYPE ");
            writer.write(name);
            if (metricFamilySamples.type == Collector.Type.COUNTER) {
                writer.write("_total");
            }
            if (metricFamilySamples.type == Collector.Type.INFO) {
                writer.write("_info");
            }
            writer.write(32);
            writer.write(TextFormat.typeString(metricFamilySamples.type));
            writer.write(10);
            String createdName = name + "_created";
            String gcountName = name + "_gcount";
            String gsumName = name + "_gsum";
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                if (sample.name.equals(createdName) || sample.name.equals(gcountName) || sample.name.equals(gsumName)) {
                    Collector.MetricFamilySamples omFamily = (Collector.MetricFamilySamples)omFamilies.get(sample.name);
                    if (omFamily == null) {
                        omFamily = new Collector.MetricFamilySamples(sample.name, Collector.Type.GAUGE, metricFamilySamples.help, new ArrayList());
                        omFamilies.put(sample.name, omFamily);
                    }
                    omFamily.samples.add(sample);
                    continue;
                }
                writer.write(sample.name);
                if (sample.labelNames.size() > 0) {
                    writer.write(123);
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        writer.write((String)sample.labelNames.get(i));
                        writer.write("=\"");
                        TextFormat.writeEscapedLabelValue(writer, (String)sample.labelValues.get(i));
                        writer.write("\",");
                    }
                    writer.write(125);
                }
                writer.write(32);
                writer.write(Collector.doubleToGoString((double)sample.value));
                if (sample.timestampMs != null) {
                    writer.write(32);
                    writer.write(sample.timestampMs.toString());
                }
                writer.write(10);
            }
        }
        if (!omFamilies.isEmpty()) {
            TextFormat.write004(writer, Collections.enumeration(omFamilies.values()));
        }
    }

    private static void writeEscapedHelp(Writer writer, String s) throws IOException {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block4;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static void writeEscapedLabelValue(Writer writer, String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    writer.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block5;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
            case GAUGE_HISTOGRAM: {
                return "histogram";
            }
            case STATE_SET: {
                return "gauge";
            }
            case INFO: {
                return "gauge";
            }
        }
        return "untyped";
    }

    public static void writeOpenMetrics100(Writer writer, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            String name = metricFamilySamples.name;
            writer.write("# TYPE ");
            writer.write(name);
            writer.write(32);
            writer.write(TextFormat.omTypeString(metricFamilySamples.type));
            writer.write(10);
            if (!metricFamilySamples.unit.isEmpty()) {
                writer.write("# UNIT ");
                writer.write(name);
                writer.write(32);
                writer.write(metricFamilySamples.unit);
                writer.write(10);
            }
            writer.write("# HELP ");
            writer.write(name);
            writer.write(32);
            TextFormat.writeEscapedLabelValue(writer, metricFamilySamples.help);
            writer.write(10);
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                int i;
                writer.write(sample.name);
                if (sample.labelNames.size() > 0) {
                    writer.write(123);
                    for (i = 0; i < sample.labelNames.size(); ++i) {
                        if (i > 0) {
                            writer.write(",");
                        }
                        writer.write((String)sample.labelNames.get(i));
                        writer.write("=\"");
                        TextFormat.writeEscapedLabelValue(writer, (String)sample.labelValues.get(i));
                        writer.write("\"");
                    }
                    writer.write(125);
                }
                writer.write(32);
                writer.write(Collector.doubleToGoString((double)sample.value));
                if (sample.timestampMs != null) {
                    writer.write(32);
                    TextFormat.omWriteTimestamp(writer, sample.timestampMs);
                }
                if (sample.exemplar != null) {
                    writer.write(" # {");
                    for (i = 0; i < sample.exemplar.getNumberOfLabels(); ++i) {
                        if (i > 0) {
                            writer.write(",");
                        }
                        writer.write(sample.exemplar.getLabelName(i));
                        writer.write("=\"");
                        TextFormat.writeEscapedLabelValue(writer, sample.exemplar.getLabelValue(i));
                        writer.write("\"");
                    }
                    writer.write("} ");
                    writer.write(Collector.doubleToGoString((double)sample.exemplar.getValue()));
                    if (sample.exemplar.getTimestampMs() != null) {
                        writer.write(32);
                        TextFormat.omWriteTimestamp(writer, sample.exemplar.getTimestampMs());
                    }
                }
                writer.write(10);
            }
        }
        writer.write("# EOF\n");
    }

    static void omWriteTimestamp(Writer writer, long timestampMs) throws IOException {
        writer.write(Long.toString(timestampMs / 1000L));
        writer.write(".");
        long ms = timestampMs % 1000L;
        if (ms < 100L) {
            writer.write("0");
        }
        if (ms < 10L) {
            writer.write("0");
        }
        writer.write(Long.toString(timestampMs % 1000L));
    }

    private static String omTypeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
            case GAUGE_HISTOGRAM: {
                return "gauge_histogram";
            }
            case STATE_SET: {
                return "stateset";
            }
            case INFO: {
                return "info";
            }
        }
        return "unknown";
    }
}

