/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ResteasyStandaloneBuildStep {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpBuildTimeConfig httpConfig, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isCapabilityPresent("io.quarkus.servlet")) {
            return;
        }
        Set<String> knownPaths = this.getClasspathResources(applicationArchivesBuildItem);
        String deploymentRootPath = null;
        String rootPath = httpConfig.rootPath;
        if (deployment != null) {
            deploymentRootPath = deployment.getRootPath();
            if (rootPath.endsWith("/")) {
                rootPath = deploymentRootPath.startsWith("/") ? rootPath + deploymentRootPath.substring(1) : rootPath + deploymentRootPath;
            } else if (!deploymentRootPath.equals("/")) {
                if (!deploymentRootPath.startsWith("/")) {
                    rootPath = rootPath + "/";
                }
                rootPath = rootPath + deploymentRootPath;
            }
            recorder.staticInit(deployment.getDeployment(), rootPath, knownPaths);
        } else if (!knownPaths.isEmpty()) {
            recorder.staticInit(null, rootPath, knownPaths);
        }
        if (deployment != null || !knownPaths.isEmpty()) {
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem(deploymentRootPath));
        }
    }

    private Set<String> getClasspathResources(ApplicationArchivesBuildItem applicationArchivesBuildItem) throws Exception {
        HashSet<String> knownPaths = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            Path resource2 = i.getChildPath(META_INF_RESOURCES);
            if (resource2 == null || !Files.exists(resource2, new LinkOption[0])) continue;
            this.collectKnownPaths(resource2, knownPaths);
        }
        ClassPathUtils.consumeAsPaths((String)META_INF_RESOURCES, resource -> this.collectKnownPaths((Path)resource, (Set<String>)knownPaths));
        return knownPaths;
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String file = resource.relativize(p).toString();
                    if (file.equals("index.html") || file.equals("index.htm")) {
                        knownPaths.add("/");
                    }
                    if (!file.startsWith("/")) {
                        file = "/" + file;
                    }
                    file = file.replace('\\', '/');
                    knownPaths.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual, ExecutorBuildItem executorBuildItem, HttpConfiguration httpConfiguration) throws Exception {
        boolean isDefaultOrNullDeploymentPath;
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        boolean bl = isDefaultOrNullDeploymentPath = standalone.deploymentRootPath == null || standalone.deploymentRootPath.equals("/");
        if (!isDefaultOrNullDeploymentPath) {
            Handler handler = recorder.vertxRequestHandler(vertx.getVertx(), beanContainer.getValue(), (Executor)executorBuildItem.getExecutorProxy(), httpConfiguration);
            routes.produce((BuildItem)new RouteBuildItem(standalone.deploymentRootPath, handler, false));
            String matchPath = standalone.deploymentRootPath;
            matchPath = matchPath.endsWith("/") ? matchPath + "*" : matchPath + "/*";
            routes.produce((BuildItem)new RouteBuildItem(matchPath, handler, false));
        }
        boolean isVirtual = requireVirtual.isPresent();
        Consumer ut = recorder.start(vertx.getVertx(), (ShutdownContext)shutdown, beanContainer.getValue(), isVirtual, isDefaultOrNullDeploymentPath, (Executor)executorBuildItem.getExecutorProxy(), httpConfiguration);
        defaultRoutes.produce((BuildItem)new DefaultRouteBuildItem(ut));
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
        final String deploymentRootPath;

        public ResteasyStandaloneBuildItem(String deploymentRootPath) {
            this.deploymentRootPath = deploymentRootPath != null ? (deploymentRootPath.startsWith("/") ? deploymentRootPath : "/" + deploymentRootPath) : null;
        }
    }
}

