/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.credential.CertificateCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.CertificateAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public class MtlsAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final String ROLES_ATTRIBUTE = "roles";
    Map<String, Set<String>> roles = Map.of();

    @Override
    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        Certificate certificate;
        HttpServerRequest request = context.request();
        if (!request.isSSL()) {
            return Uni.createFrom().nullItem();
        }
        try {
            certificate = request.sslSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            return Uni.createFrom().nullItem();
        }
        context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
        CertificateAuthenticationRequest authRequest = new CertificateAuthenticationRequest(new CertificateCredential((X509Certificate)X509Certificate.class.cast(certificate)));
        authRequest.setAttribute(ROLES_ATTRIBUTE, this.roles);
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)authRequest, context));
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(CertificateAuthenticationRequest.class);
    }

    @Override
    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.X509, "X509"));
    }

    void setRoleMappings(Map<String, Set<String>> roles) {
        this.roles = Collections.unmodifiableMap(roles);
    }
}

