/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.channel.AppendTransformerEvent;
import io.reactivex.netty.channel.WriteTransformations;
import io.reactivex.netty.client.ClientConnectionToChannelBridge;
import java.util.List;

public class WriteTransformer
extends MessageToMessageCodec<Object, Object> {
    private final WriteTransformations transformations = new WriteTransformations();

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return false;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (!this.transformations.transform(msg, ctx.alloc(), out)) {
            out.add(ReferenceCountUtil.retain((Object)msg));
        }
    }

    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof AppendTransformerEvent) {
            AppendTransformerEvent ate = (AppendTransformerEvent)evt;
            this.transformations.appendTransformer(ate.getTransformer());
        } else if (evt instanceof ClientConnectionToChannelBridge.ConnectionReuseEvent) {
            this.transformations.resetTransformations();
        }
        super.userEventTriggered(ctx, evt);
    }
}

