/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.ssl;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.reactivex.netty.HandlerNames;
import io.reactivex.netty.channel.ConnectionCreationFailedEvent;
import io.reactivex.netty.channel.EmitConnectionEvent;
import rx.functions.Action1;

public abstract class SslCodec
implements Action1<ChannelPipeline> {
    protected SslCodec() {
    }

    public final void call(ChannelPipeline pipeline) {
        SslHandler sslHandler = this.newSslHandler(pipeline);
        ChannelHandler wireLogging = pipeline.get(HandlerNames.WireLogging.getName());
        if (null != wireLogging) {
            pipeline.addAfter(HandlerNames.WireLogging.getName(), HandlerNames.SslHandler.getName(), (ChannelHandler)sslHandler);
        } else {
            pipeline.addFirst(HandlerNames.SslHandler.getName(), (ChannelHandler)sslHandler);
        }
        pipeline.addAfter(HandlerNames.SslHandler.getName(), HandlerNames.SslConnectionEmissionHandler.getName(), (ChannelHandler)new SslConnEmissionHandler());
    }

    protected abstract SslHandler newSslHandler(ChannelPipeline var1);

    private static final class SslConnEmissionHandler
    extends ChannelDuplexHandler {
        private boolean handshakeDone;

        private SslConnEmissionHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
            super.channelActive(ctx);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.handshakeDone) {
                ctx.read();
            }
            super.channelReadComplete(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                this.handshakeDone = true;
                SslHandshakeCompletionEvent handshakeCompletionEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeCompletionEvent.isSuccess()) {
                    ctx.fireUserEventTriggered((Object)EmitConnectionEvent.INSTANCE);
                } else {
                    ctx.fireUserEventTriggered((Object)new ConnectionCreationFailedEvent(handshakeCompletionEvent.cause()));
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

