/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.threads;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PreferCurrentEventLoopGroup
implements EventLoopGroup {
    private final FastThreadLocal<EventLoop> self = new FastThreadLocal();
    private final EventLoopGroup delegate;

    public PreferCurrentEventLoopGroup(EventLoopGroup delegate) {
        this.delegate = delegate;
        for (final EventExecutor child : delegate) {
            child.submit(new Runnable(){

                @Override
                public void run() {
                    if (child instanceof EventLoop) {
                        PreferCurrentEventLoopGroup.this.self.set((Object)((EventLoop)child));
                    }
                }
            });
        }
    }

    public EventLoop next() {
        EventLoop thisEventLoop = (EventLoop)this.self.get();
        return null != thisEventLoop ? thisEventLoop : this.delegate.next();
    }

    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    public io.netty.util.concurrent.Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    public io.netty.util.concurrent.Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public io.netty.util.concurrent.Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Deprecated
    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    public io.netty.util.concurrent.Future<?> submit(Runnable task) {
        return this.next().submit(task);
    }

    public <T> io.netty.util.concurrent.Future<T> submit(Runnable task, T result) {
        return this.next().submit(task, result);
    }

    public <T> io.netty.util.concurrent.Future<T> submit(Callable<T> task) {
        return this.next().submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.next().schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.next().schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.next().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.next().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.next().invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.next().invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.next().invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.next().invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.next().execute(command);
    }
}

