/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.threads;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.threads.PreferCurrentEventLoopGroup;
import io.reactivex.netty.threads.RxDefaultThreadFactory;
import io.reactivex.netty.threads.RxEventLoopProvider;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public class SingleNioLoopProvider
extends RxEventLoopProvider {
    private final EventLoopGroup eventLoop;
    private final EventLoopGroup clientEventLoop;
    private final EventLoopGroup parentEventLoop;
    private final AtomicReference<EventLoopGroup> nativeEventLoop;
    private final AtomicReference<EventLoopGroup> nativeClientEventLoop;
    private final AtomicReference<EventLoopGroup> nativeParentEventLoop;
    private final int parentEventLoopCount;
    private final int childEventLoopCount;

    public SingleNioLoopProvider() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public SingleNioLoopProvider(int threadCount) {
        this.eventLoop = new NioEventLoopGroup(threadCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-nio-eventloop")));
        this.clientEventLoop = new PreferCurrentEventLoopGroup(this.eventLoop);
        this.parentEventLoop = this.eventLoop;
        this.parentEventLoopCount = this.childEventLoopCount = threadCount;
        this.nativeEventLoop = new AtomicReference();
        this.nativeClientEventLoop = new AtomicReference();
        this.nativeParentEventLoop = this.nativeEventLoop;
    }

    public SingleNioLoopProvider(int parentEventLoopCount, int childEventLoopCount) {
        this.parentEventLoopCount = parentEventLoopCount;
        this.childEventLoopCount = childEventLoopCount;
        this.parentEventLoop = new NioEventLoopGroup(parentEventLoopCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-nio-eventloop")));
        this.eventLoop = new NioEventLoopGroup(childEventLoopCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-nio-eventloop")));
        this.clientEventLoop = new PreferCurrentEventLoopGroup(this.eventLoop);
        this.nativeParentEventLoop = new AtomicReference();
        this.nativeEventLoop = new AtomicReference();
        this.nativeClientEventLoop = new AtomicReference();
    }

    @Override
    public EventLoopGroup globalClientEventLoop() {
        return this.clientEventLoop;
    }

    @Override
    public EventLoopGroup globalServerEventLoop() {
        return this.eventLoop;
    }

    @Override
    public EventLoopGroup globalServerParentEventLoop() {
        return this.parentEventLoop;
    }

    @Override
    public EventLoopGroup globalClientEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeClientEventLoop();
        }
        return this.globalClientEventLoop();
    }

    @Override
    public EventLoopGroup globalServerEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeEventLoop();
        }
        return this.globalServerEventLoop();
    }

    @Override
    public EventLoopGroup globalServerParentEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeParentEventLoop();
        }
        return this.globalServerParentEventLoop();
    }

    private EventLoopGroup getNativeParentEventLoop() {
        EpollEventLoopGroup newEventLoopGroup;
        if (this.nativeParentEventLoop == this.nativeEventLoop) {
            return this.getNativeEventLoop();
        }
        EventLoopGroup eventLoopGroup = this.nativeParentEventLoop.get();
        if (null == eventLoopGroup && !this.nativeParentEventLoop.compareAndSet(null, (EventLoopGroup)(newEventLoopGroup = new EpollEventLoopGroup(this.parentEventLoopCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-epoll-eventloop")))))) {
            newEventLoopGroup.shutdownGracefully();
        }
        return this.nativeParentEventLoop.get();
    }

    private EventLoopGroup getNativeEventLoop() {
        EpollEventLoopGroup newEventLoopGroup;
        EventLoopGroup eventLoopGroup = this.nativeEventLoop.get();
        if (null == eventLoopGroup && !this.nativeEventLoop.compareAndSet(null, (EventLoopGroup)(newEventLoopGroup = new EpollEventLoopGroup(this.childEventLoopCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-epoll-eventloop")))))) {
            newEventLoopGroup.shutdownGracefully();
        }
        return this.nativeEventLoop.get();
    }

    private EventLoopGroup getNativeClientEventLoop() {
        EventLoopGroup eventLoopGroup = this.nativeClientEventLoop.get();
        if (null == eventLoopGroup) {
            Object newEventLoopGroup = new EpollEventLoopGroup(this.childEventLoopCount, (ThreadFactory)((Object)new RxDefaultThreadFactory("rxnetty-epoll-eventloop")));
            if (!this.nativeClientEventLoop.compareAndSet(null, (EventLoopGroup)(newEventLoopGroup = new PreferCurrentEventLoopGroup((EventLoopGroup)newEventLoopGroup)))) {
                newEventLoopGroup.shutdownGracefully();
            }
        }
        return this.nativeClientEventLoop.get();
    }
}

