/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.channel.ChannelOperations;
import io.reactivex.netty.events.Clock;
import io.reactivex.netty.protocol.http.internal.AbstractHttpConnectionBridge;
import io.reactivex.netty.protocol.http.internal.HttpContentSubscriberEvent;
import io.reactivex.netty.protocol.http.server.HttpServerRequestImpl;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventPublisher;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class HttpServerToConnectionBridge<C>
extends AbstractHttpConnectionBridge<C> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerToConnectionBridge.class);
    private volatile boolean activeContentSubscriberExists;
    private final Object contentSubGuard = new Object();
    private Queue<HttpContentSubscriberEvent<?>> pendingContentSubs;
    private final HttpServerEventPublisher eventPublisher;
    private int lastSeenResponseCode;

    public HttpServerToConnectionBridge(HttpServerEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected void beforeOutboundHeaderWrite(HttpMessage httpMsg, ChannelPromise promise, long startTimeNanos) {
        HttpResponse response = (HttpResponse)httpMsg;
        if (this.eventPublisher.publishingEnabled()) {
            this.eventPublisher.onResponseWriteStart();
        }
        this.lastSeenResponseCode = response.status().code();
    }

    @Override
    protected void onOutboundLastContentWrite(LastHttpContent msg, ChannelPromise promise, final long headerWriteStartTimeNanos) {
        final int _responseCode = this.lastSeenResponseCode;
        if (this.eventPublisher.publishingEnabled()) {
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (HttpServerToConnectionBridge.this.eventPublisher.publishingEnabled()) {
                        long endNanos = Clock.onEndNanos((long)headerWriteStartTimeNanos);
                        if (future.isSuccess()) {
                            HttpServerToConnectionBridge.this.eventPublisher.onResponseWriteSuccess(endNanos, TimeUnit.NANOSECONDS, _responseCode);
                        } else {
                            HttpServerToConnectionBridge.this.eventPublisher.onResponseWriteFailed(endNanos, TimeUnit.NANOSECONDS, future.cause());
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpContentSubscriberEvent) {
            HttpContentSubscriberEvent subscriberEvent = (HttpContentSubscriberEvent)evt;
            subscriberEvent.getSubscriber().add(Subscriptions.create((Action0)new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    HttpContentSubscriberEvent nextSub = null;
                    Object object = HttpServerToConnectionBridge.this.contentSubGuard;
                    synchronized (object) {
                        if (null != HttpServerToConnectionBridge.this.pendingContentSubs) {
                            nextSub = (HttpContentSubscriberEvent)HttpServerToConnectionBridge.this.pendingContentSubs.poll();
                        }
                    }
                    HttpServerToConnectionBridge.this.activeContentSubscriberExists = null != nextSub;
                    if (null != nextSub) {
                        HttpServerToConnectionBridge.this.fireContentSubscriberEvent(ctx, nextSub);
                    }
                }
            }));
            if (this.activeContentSubscriberExists) {
                Object object = this.contentSubGuard;
                synchronized (object) {
                    if (null == this.pendingContentSubs) {
                        this.pendingContentSubs = new ArrayDeque();
                    }
                    this.pendingContentSubs.add(subscriberEvent);
                }
                return;
            }
            this.activeContentSubscriberExists = true;
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected boolean isInboundHeader(Object nextItem) {
        return nextItem instanceof HttpRequest;
    }

    @Override
    protected boolean isOutboundHeader(Object nextItem) {
        return nextItem instanceof HttpResponse;
    }

    @Override
    protected Object newHttpObject(Object nextItem, Channel channel) {
        if (this.eventPublisher.publishingEnabled()) {
            this.eventPublisher.onRequestHeadersReceived();
        }
        return new HttpServerRequestImpl((HttpRequest)nextItem, channel);
    }

    @Override
    protected void onContentReceived() {
        if (this.eventPublisher.publishingEnabled()) {
            this.eventPublisher.onRequestContentReceived();
        }
    }

    @Override
    protected void onContentReceiveComplete(long receiveStartTimeNanos) {
        if (this.eventPublisher.publishingEnabled()) {
            this.eventPublisher.onRequestReceiveComplete(Clock.onEndNanos((long)receiveStartTimeNanos), TimeUnit.NANOSECONDS);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        Boolean shouldFlush = (Boolean)ctx.channel().attr(ChannelOperations.FLUSH_ONLY_ON_READ_COMPLETE).get();
        if (null != shouldFlush && shouldFlush.booleanValue()) {
            ctx.flush();
        }
    }

    private void fireContentSubscriberEvent(ChannelHandlerContext ctx, HttpContentSubscriberEvent<?> event) {
        try {
            super.userEventTriggered(ctx, event);
        }
        catch (Exception e) {
            try {
                this.exceptionCaught(ctx, e);
            }
            catch (Exception e1) {
                logger.error("Exception while handling error in handler.", (Throwable)e1);
            }
        }
    }
}

