/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;

public class UriInfoHolder {
    private final String uri;
    private final String queryString;
    private final QueryStringDecoder decoder;

    public UriInfoHolder(String uri) {
        this.uri = uri;
        int indexOfStartOfQP = uri.indexOf(63);
        this.queryString = -1 != indexOfStartOfQP && uri.length() >= indexOfStartOfQP ? uri.substring(indexOfStartOfQP + 1) : "";
        this.decoder = new QueryStringDecoder(UriInfoHolder.getPath(uri));
    }

    private static String getPath(String uri) {
        int offset = 0;
        if (uri.startsWith("http://")) {
            offset = "http://".length();
        } else if (uri.startsWith("https://")) {
            offset = "https://".length();
        }
        if (offset == 0) {
            return uri;
        }
        int firstSlash = uri.indexOf(47, offset);
        return -1 != firstSlash ? uri.substring(firstSlash) : uri;
    }

    public String getRawUriString() {
        return this.uri;
    }

    public synchronized String getPath() {
        return this.decoder.path();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public synchronized Map<String, List<String>> getQueryParameters() {
        return this.decoder.parameters();
    }
}

