/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandler;
import rx.Observable;

public final class WebSocketHandlers {
    private WebSocketHandlers() {
    }

    public static <I, O> RequestHandler<I, O> acceptAllUpgrades(final WebSocketHandler handler) {
        return new RequestHandler<I, O>(){

            @Override
            public Observable<Void> handle(HttpServerRequest<I> request, HttpServerResponse<O> response) {
                if (request.isWebSocketUpgradeRequested()) {
                    return response.acceptWebSocketUpgrade(handler);
                }
                return response.setStatus(HttpResponseStatus.NOT_FOUND).write(Observable.empty());
            }
        };
    }
}

