/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import io.reactivex.netty.spectator.http.internal.ResponseCodesHolder;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;

public class HttpServerListener
extends HttpServerEventsListener {
    private final EventMetric requestRead;
    private final EventMetric requestProcessing;
    private final EventMetric responseWrite;
    private final ResponseCodesHolder responseCodesHolder;
    private final TcpServerListener tcpDelegate;

    public HttpServerListener(String monitorId) {
        this((Registry)Spectator.globalRegistry(), monitorId);
    }

    public HttpServerListener(Registry registry, String monitorId) {
        this.requestRead = new EventMetric(registry, "request", monitorId, new String[]{"action", "read"});
        this.requestProcessing = new EventMetric(registry, "request", monitorId, new String[]{"action", "processing"});
        this.responseWrite = new EventMetric(registry, "response", monitorId, new String[]{"action", "write"});
        this.responseCodesHolder = new ResponseCodesHolder(registry, monitorId);
        this.tcpDelegate = new TcpServerListener(registry, monitorId);
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    public void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.requestProcessing.failure(duration, timeUnit);
    }

    public void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.requestProcessing.success(duration, timeUnit);
    }

    public void onResponseWriteSuccess(long duration, TimeUnit timeUnit, int responseCode) {
        this.responseWrite.success(duration, timeUnit);
    }

    public void onResponseWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.responseWrite.failure(duration, timeUnit);
    }

    public void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        this.requestRead.success(duration, timeUnit);
    }

    public void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
        this.requestProcessing.start(duration, timeUnit);
    }

    public void onRequestHeadersReceived() {
        this.requestRead.start();
    }

    public void onResponseWriteStart() {
        this.responseWrite.start();
    }

    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
    }

    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingSuccess(duration, timeUnit);
    }

    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingStart(duration, timeUnit);
    }

    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    public void onNewClientConnected() {
        this.tcpDelegate.onNewClientConnected();
    }

    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }
}

