/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.client.ChannelProviderFactory;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.protocol.tcp.client.InterceptingTcpClient;
import io.reactivex.netty.protocol.tcp.client.TcpClientImpl;
import io.reactivex.netty.ssl.SslCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public abstract class TcpClient<W, R>
extends InterceptingTcpClient<W, R> {
    public abstract <T> TcpClient<W, R> channelOption(ChannelOption<T> var1, T var2);

    public abstract TcpClient<W, R> readTimeOut(int var1, TimeUnit var2);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerFirst(String var1, Func0<ChannelHandler> var2);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerFirst(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerLast(String var1, Func0<ChannelHandler> var2);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerLast(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerBefore(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerBefore(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerAfter(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <WW, RR> TcpClient<WW, RR> addChannelHandlerAfter(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <WW, RR> TcpClient<WW, RR> pipelineConfigurator(Action1<ChannelPipeline> var1);

    @Deprecated
    public abstract TcpClient<W, R> enableWireLogging(LogLevel var1);

    public abstract TcpClient<W, R> enableWireLogging(String var1, LogLevel var2);

    public abstract TcpClient<W, R> secure(Func1<ByteBufAllocator, SSLEngine> var1);

    public abstract TcpClient<W, R> secure(SSLEngine var1);

    public abstract TcpClient<W, R> secure(SslCodec var1);

    public abstract TcpClient<W, R> unsafeSecure();

    public abstract TcpClient<W, R> channelProvider(ChannelProviderFactory var1);

    public static TcpClient<ByteBuf, ByteBuf> newClient(String host, int port) {
        return TcpClient.newClient(new InetSocketAddress(host, port));
    }

    public static TcpClient<ByteBuf, ByteBuf> newClient(SocketAddress serverAddress) {
        return TcpClientImpl.create(serverAddress);
    }

    public static TcpClient<ByteBuf, ByteBuf> newClient(SocketAddress serverAddress, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        return TcpClientImpl.create(serverAddress, eventLoopGroup, channelClass);
    }

    public static TcpClient<ByteBuf, ByteBuf> newClient(ConnectionProviderFactory<ByteBuf, ByteBuf> providerFactory, Observable<Host> hostStream) {
        return TcpClientImpl.create(providerFactory, hostStream);
    }
}

