/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import io.seata.common.util.StringUtils;
import io.seata.saga.statelang.domain.RecoverStrategy;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.BaseState;
import io.seata.saga.statelang.domain.impl.StateMachineImpl;
import io.seata.saga.statelang.parser.JsonParser;
import io.seata.saga.statelang.parser.JsonParserFactory;
import io.seata.saga.statelang.parser.StateMachineParser;
import io.seata.saga.statelang.parser.StateParser;
import io.seata.saga.statelang.parser.StateParserFactory;
import io.seata.saga.statelang.parser.utils.DesignerJsonTransformer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineParserImpl
implements StateMachineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineParserImpl.class);
    private String jsonParserName = "fastjson";

    @Override
    public StateMachine parse(String json) {
        Object isPersist;
        JsonParser jsonParser = JsonParserFactory.getJsonParser(this.jsonParserName);
        if (jsonParser == null) {
            throw new RuntimeException("Cannot find JsonParer by name: " + this.jsonParserName);
        }
        Map<String, Object> node = jsonParser.parse(json, Map.class, true);
        if (DesignerJsonTransformer.isDesignerJson(node)) {
            node = DesignerJsonTransformer.toStandardJson(node);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("===== Transformed standard state language:\n{}", (Object)jsonParser.toJsonString(node, true));
            }
        }
        StateMachineImpl stateMachine = new StateMachineImpl();
        stateMachine.setName((String)node.get("Name"));
        stateMachine.setComment((String)node.get("Comment"));
        stateMachine.setVersion((String)node.get("Version"));
        stateMachine.setStartState((String)node.get("StartState"));
        String recoverStrategy = (String)node.get("RecoverStrategy");
        if (StringUtils.isNotBlank(recoverStrategy)) {
            stateMachine.setRecoverStrategy(RecoverStrategy.valueOf(recoverStrategy));
        }
        if (Boolean.FALSE.equals(isPersist = node.get("IsPersist"))) {
            stateMachine.setPersist(false);
        }
        Map statesNode = (Map)node.get("States");
        for (String stateName : statesNode.keySet()) {
            Map stateNode = (Map)statesNode.get(stateName);
            String stateType = (String)stateNode.get("Type");
            StateParser stateParser = StateParserFactory.getStateParser(stateType);
            if (stateParser == null) {
                throw new IllegalArgumentException("State Type [" + stateType + "] is not support");
            }
            Object state = stateParser.parse(stateNode);
            if (state instanceof BaseState) {
                ((BaseState)state).setName(stateName);
            }
            if (stateMachine.getState(stateName) != null) {
                throw new IllegalArgumentException("State[name:" + stateName + "] is already exists");
            }
            stateMachine.putState(stateName, (State)state);
        }
        Map<String, State> stateMap = stateMachine.getStates();
        for (String name : stateMap.keySet()) {
            AbstractTaskState taskState;
            State state = stateMap.get(name);
            if (!(state instanceof AbstractTaskState) || !StringUtils.isNotBlank((taskState = (AbstractTaskState)state).getCompensateState())) continue;
            taskState.setForUpdate(true);
            State compState = stateMap.get(taskState.getCompensateState());
            if (compState == null || !(compState instanceof AbstractTaskState)) continue;
            ((AbstractTaskState)compState).setForCompensation(true);
        }
        return stateMachine;
    }

    public String getJsonParserName() {
        return this.jsonParserName;
    }

    public void setJsonParserName(String jsonParserName) {
        this.jsonParserName = jsonParserName;
    }
}

