/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.resource.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.ReflectionUtil;
import io.seata.common.util.StringUtils;
import io.seata.integration.tx.api.interceptor.ActionContextUtil;
import io.seata.integration.tx.api.interceptor.TxBeanParserUtils;
import io.seata.integration.tx.api.interceptor.parser.RegisterResourceParser;
import io.seata.integration.tx.api.remoting.RemotingDesc;
import io.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.TCCResource;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TccRegisterResourceParser
implements RegisterResourceParser {
    @Override
    public void registerResource(Object target, String beanName) {
        RemotingDesc remotingDesc;
        boolean isTxRemotingBean = TxBeanParserUtils.isTxRemotingBean(target, beanName);
        if (isTxRemotingBean && (remotingDesc = DefaultRemotingParser.get().getRemotingBeanDesc(target)) != null && remotingDesc.isService()) {
            try {
                Class<?> serviceClass = remotingDesc.getServiceClass();
                HashSet<Method> methods = new HashSet<Method>(Arrays.asList(serviceClass.getMethods()));
                Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(serviceClass);
                if (interfaceClasses != null) {
                    for (Class<?> interClass : interfaceClasses) {
                        methods.addAll(Arrays.asList(interClass.getMethods()));
                    }
                }
                Object targetBean = remotingDesc.getTargetBean();
                for (Method m : methods) {
                    TwoPhaseBusinessAction twoPhaseBusinessAction = m.getAnnotation(TwoPhaseBusinessAction.class);
                    if (twoPhaseBusinessAction == null) continue;
                    TCCResource tccResource = new TCCResource();
                    if (StringUtils.isBlank(twoPhaseBusinessAction.name())) {
                        throw new FrameworkException("TCC bean name cannot be null or empty");
                    }
                    tccResource.setActionName(twoPhaseBusinessAction.name());
                    tccResource.setTargetBean(targetBean);
                    tccResource.setPrepareMethod(m);
                    tccResource.setCommitMethodName(twoPhaseBusinessAction.commitMethod());
                    tccResource.setCommitMethod(serviceClass.getMethod(twoPhaseBusinessAction.commitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
                    tccResource.setRollbackMethodName(twoPhaseBusinessAction.rollbackMethod());
                    tccResource.setRollbackMethod(serviceClass.getMethod(twoPhaseBusinessAction.rollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
                    tccResource.setCommitArgsClasses(twoPhaseBusinessAction.commitArgsClasses());
                    tccResource.setRollbackArgsClasses(twoPhaseBusinessAction.rollbackArgsClasses());
                    tccResource.setPhaseTwoCommitKeys(this.getTwoPhaseArgs(tccResource.getCommitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
                    tccResource.setPhaseTwoRollbackKeys(this.getTwoPhaseArgs(tccResource.getRollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
                    DefaultResourceManager.get().registerResource(tccResource);
                }
            }
            catch (Throwable t) {
                throw new FrameworkException(t, "parser remoting service error");
            }
        }
    }

    protected String[] getTwoPhaseArgs(Method method, Class<?>[] argsClasses) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] keys = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                String key;
                if (!(parameterAnnotations[i][j] instanceof BusinessActionContextParameter)) continue;
                BusinessActionContextParameter param = (BusinessActionContextParameter)parameterAnnotations[i][j];
                keys[i] = key = ActionContextUtil.getParamNameFromAnnotation(param);
                break;
            }
            if (keys[i] != null || argsClasses[i].equals(BusinessActionContext.class)) continue;
            throw new IllegalArgumentException("non-BusinessActionContext parameter should use annotation BusinessActionContextParameter");
        }
        return keys;
    }
}

