/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.common.javassist;

import com.fasterxml.jackson.databind.JavaType;
import io.servicecomb.common.javassist.JavassistUtils;
import io.servicecomb.common.javassist.ParameterConfig;
import java.util.ArrayList;
import java.util.List;

public class MethodConfig {
    private String name;
    private JavaType result;
    private List<ParameterConfig> parameterList = new ArrayList<ParameterConfig>();
    private String bodySource;
    private String source;
    private String genericSignature;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getGenericSignature() {
        return this.genericSignature;
    }

    public void setGenericSignature(String genericSignature) {
        this.genericSignature = genericSignature;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResult(JavaType result) {
        this.result = result;
    }

    public void addParameter(String name, JavaType type) {
        ParameterConfig parameterConfig = new ParameterConfig();
        parameterConfig.setName(name);
        parameterConfig.setType(type);
        this.parameterList.add(parameterConfig);
    }

    public void setBodySource(String bodySource) {
        this.bodySource = bodySource;
    }

    void init() {
        if (this.source != null) {
            return;
        }
        StringBuilder sbMethod = new StringBuilder();
        StringBuilder sbMethodGenericSignature = new StringBuilder();
        sbMethod.append("public ");
        sbMethod.append(this.result == null ? "void" : JavassistUtils.getNameForGenerateCode(this.result));
        sbMethod.append(" ").append(this.name).append("(");
        sbMethodGenericSignature.append("(");
        boolean hasGenericSignature = this.result == null ? false : this.result.hasGenericTypes();
        for (ParameterConfig parameter : this.parameterList) {
            hasGenericSignature = hasGenericSignature || parameter.getType().hasGenericTypes();
            String paramTypeName = JavassistUtils.getNameForGenerateCode(parameter.getType());
            String code = String.format("%s %s,", paramTypeName, parameter.getName());
            sbMethod.append(code);
            sbMethodGenericSignature.append(parameter.getType().getGenericSignature());
        }
        if (!this.parameterList.isEmpty()) {
            sbMethod.setLength(sbMethod.length() - 1);
        }
        sbMethod.append(")");
        sbMethodGenericSignature.append(")");
        sbMethodGenericSignature.append(this.result == null ? "V" : this.result.getGenericSignature());
        if (this.bodySource != null) {
            sbMethod.append("{").append(this.bodySource).append("}");
        } else {
            sbMethod.append(";");
        }
        this.source = sbMethod.toString();
        if (hasGenericSignature) {
            this.genericSignature = sbMethodGenericSignature.toString();
        }
    }
}

