/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.vertx.server;

import io.servicecomb.foundation.common.net.URIEndpointObject;
import io.servicecomb.foundation.ssl.SSLCustom;
import io.servicecomb.foundation.ssl.SSLOption;
import io.servicecomb.foundation.ssl.SSLOptionFactory;
import io.servicecomb.foundation.vertx.AsyncResultCallback;
import io.servicecomb.foundation.vertx.VertxTLSBuilder;
import io.servicecomb.foundation.vertx.server.TcpServerConnection;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import java.net.InetSocketAddress;

public class TcpServer {
    private URIEndpointObject endpointObject;

    public TcpServer(URIEndpointObject endpointObject) {
        this.endpointObject = endpointObject;
    }

    public void init(Vertx vertx, String sslKey, AsyncResultCallback<InetSocketAddress> callback) {
        NetServer netServer;
        if (this.endpointObject.isSslEnabled()) {
            SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)sslKey, null);
            SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)sslKey) : factory.createSSLOption();
            SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
            NetServerOptions serverOptions = new NetServerOptions();
            VertxTLSBuilder.buildNetServerOptions(sslOption, sslCustom, serverOptions);
            netServer = vertx.createNetServer(serverOptions);
        } else {
            netServer = vertx.createNetServer();
        }
        netServer.connectHandler(netSocket -> {
            TcpServerConnection connection = this.createTcpServerConnection();
            connection.init((NetSocket)netSocket);
        });
        InetSocketAddress socketAddress = this.endpointObject.getSocketAddress();
        netServer.listen(socketAddress.getPort(), socketAddress.getHostString(), ar -> {
            if (ar.succeeded()) {
                callback.success(socketAddress);
                return;
            }
            String msg = String.format("listen failed, address=%s", socketAddress.toString());
            callback.fail(new Exception(msg, ar.cause()));
        });
    }

    protected TcpServerConnection createTcpServerConnection() {
        return new TcpServerConnection();
    }
}

