/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.api.registry;

import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.config.ConfigurePropertyUtils;
import io.servicecomb.serviceregistry.config.MicroservicePropertiesLoader;
import io.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class MicroserviceFactory {
    public Microservice create(String appId, String microserviceName) {
        MicroserviceDefinition microserviceDefinition = MicroserviceDefinition.create(appId, microserviceName);
        return this.create(microserviceDefinition);
    }

    public Microservice create(MicroserviceDefinition microserviceDefinition) {
        Configuration configuration = microserviceDefinition.getConfiguration();
        Microservice microservice = this.createMicroserviceFromDefinition(configuration);
        microservice.setIntance(MicroserviceInstance.createFromDefinition(configuration));
        return microservice;
    }

    private Microservice createMicroserviceFromDefinition(Configuration configuration) {
        Microservice microservice = new Microservice();
        microservice.setServiceName(configuration.getString("service_description.name", "defaultMicroservice"));
        microservice.setAppId(configuration.getString("APPLICATION_ID", "default"));
        microservice.setVersion(configuration.getString("service_description.version", "1.0.0"));
        microservice.setDescription(configuration.getString("service_description.description", ""));
        microservice.setLevel(configuration.getString("service_description.role", "FRONT"));
        microservice.setPaths(ConfigurePropertyUtils.getMicroservicePaths(configuration));
        Map<String, String> propertiesMap = MicroservicePropertiesLoader.INSTANCE.loadProperties(configuration);
        microservice.setProperties(propertiesMap);
        if (this.allowCrossApp(propertiesMap)) {
            microservice.setAlias(Microservice.generateAbsoluteMicroserviceName(microservice.getAppId(), microservice.getServiceName()));
        }
        return microservice;
    }

    private boolean allowCrossApp(Map<String, String> propertiesMap) {
        return Boolean.valueOf(propertiesMap.get("allowCrossApp"));
    }
}

