/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.client;

import io.servicecomb.foundation.common.net.IpPort;
import io.servicecomb.foundation.common.net.URIEndpointObject;
import io.servicecomb.serviceregistry.cache.CacheEndpoint;
import io.servicecomb.serviceregistry.cache.InstanceCache;
import io.servicecomb.serviceregistry.cache.InstanceCacheManager;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpPortManager.class);
    private ServiceRegistryConfig serviceRegistryConfig;
    private InstanceCacheManager instanceCacheManager;
    private String defaultTransport = "rest";
    private ArrayList<IpPort> defaultIpPort;
    private InstanceCache instanceCache = null;
    private AtomicInteger currentAvailbleIndex;

    public IpPortManager(ServiceRegistryConfig serviceRegistryConfig, InstanceCacheManager instanceCacheManager) {
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.instanceCacheManager = instanceCacheManager;
        this.defaultTransport = serviceRegistryConfig.getTransport();
        this.defaultIpPort = serviceRegistryConfig.getIpPort();
        if (this.defaultIpPort.size() == 0) {
            throw new IllegalArgumentException("Service center address is required to start the application.");
        }
        int initialIndex = new Random().nextInt(this.defaultIpPort.size());
        this.currentAvailbleIndex = new AtomicInteger(initialIndex);
    }

    public void initAutoDiscovery() {
        if (this.serviceRegistryConfig.isRegistryAutoDiscovery()) {
            this.instanceCache = this.instanceCacheManager.getOrCreate("default", "SERVICECENTER", "latest");
        }
    }

    public IpPort getAvailableAddress(boolean invalidate) {
        int index = invalidate ? this.currentAvailbleIndex.incrementAndGet() : this.currentAvailbleIndex.get();
        if (index < this.defaultIpPort.size()) {
            return this.returnWithLog(invalidate, this.defaultIpPort.get(index));
        }
        List<CacheEndpoint> endpoints = this.getDiscoveredIpPort();
        if (index >= this.defaultIpPort.size() + endpoints.size()) {
            this.currentAvailbleIndex.set(0);
            return this.returnWithLog(invalidate, this.defaultIpPort.get(0));
        }
        CacheEndpoint nextEndpoint = endpoints.get(index - this.defaultIpPort.size());
        return this.returnWithLog(invalidate, (IpPort)new URIEndpointObject(nextEndpoint.getEndpoint()));
    }

    private IpPort returnWithLog(boolean needLog, IpPort result) {
        if (needLog) {
            LOGGER.info("Using next service center address {}:{}.", (Object)result.getHostOrIp(), (Object)result.getPort());
        }
        return result;
    }

    private List<CacheEndpoint> getDiscoveredIpPort() {
        if (this.instanceCache == null) {
            return new ArrayList<CacheEndpoint>(0);
        }
        this.instanceCache = this.instanceCacheManager.getOrCreate("default", "SERVICECENTER", "latest");
        return this.instanceCache.getOrCreateTransportMap().get(this.defaultTransport);
    }
}

