/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.client.http;

import io.servicecomb.foundation.ssl.SSLCustom;
import io.servicecomb.foundation.ssl.SSLOption;
import io.servicecomb.foundation.ssl.SSLOptionFactory;
import io.servicecomb.foundation.vertx.VertxTLSBuilder;
import io.servicecomb.foundation.vertx.VertxUtils;
import io.servicecomb.foundation.vertx.client.ClientPoolManager;
import io.servicecomb.foundation.vertx.client.http.HttpClientVerticle;
import io.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import io.servicecomb.serviceregistry.client.http.ClientPool;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientPool
implements ClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientPool.class);
    private ClientPoolManager<HttpClientWithContext> clientMgr = new ClientPoolManager();
    private static final String SSL_KEY = "sc.consumer";

    public AbstractClientPool() {
        this.create();
    }

    @Override
    public HttpClientWithContext getClient() {
        return (HttpClientWithContext)this.clientMgr.findThreadBindClientPool();
    }

    @Override
    public void create() {
        Vertx vertx = VertxUtils.getOrCreateVertxByName((String)"registry", null);
        HttpClientOptions httpClientOptions = this.createHttpClientOptions();
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)ServiceRegistryConfig.INSTANCE.getWorkerPoolSize(), (int)1, (Object)httpClientOptions);
        try {
            VertxUtils.blockDeploy((Vertx)vertx, HttpClientVerticle.class, (DeploymentOptions)deployOptions);
        }
        catch (InterruptedException e) {
            LOGGER.error("deploy a registry verticle failed, {}", (Object)e.getMessage());
        }
    }

    protected void buildSecureClientOptions(HttpClientOptions httpClientOptions) {
        SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, null);
        SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)SSL_KEY) : factory.createSSLOption();
        SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
        VertxTLSBuilder.buildHttpClientOptions((SSLOption)sslOption, (SSLCustom)sslCustom, (HttpClientOptions)httpClientOptions);
    }
}

