/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.Subscribe;
import io.servicecomb.serviceregistry.consumer.AppManager;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import io.servicecomb.serviceregistry.task.event.PeriodicPullEvent;
import io.servicecomb.serviceregistry.task.event.RecoveryEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MicroserviceManager {
    private AppManager appManager;
    private String appId;
    private Map<String, MicroserviceVersions> versionsByName = new ConcurrentHashMap<String, MicroserviceVersions>();

    public MicroserviceManager(AppManager appManager, String appId) {
        this.appManager = appManager;
        this.appId = appId;
        appManager.getEventBus().register((Object)this);
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String microserviceName) {
        return this.versionsByName.computeIfAbsent(microserviceName, name -> {
            MicroserviceVersions instance = new MicroserviceVersions(this.appManager, this.appId, microserviceName);
            instance.submitPull();
            return instance;
        });
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String microserviceName, String versionRule) {
        MicroserviceVersions microserviceVersions = this.getOrCreateMicroserviceVersions(microserviceName);
        return microserviceVersions.getOrCreateMicroserviceVersionRule(versionRule);
    }

    @Subscribe
    public void periodicPull(PeriodicPullEvent event) {
        this.refreshInstances();
    }

    @Subscribe
    public void serviceRegistryRecovery(RecoveryEvent event) {
        this.refreshInstances();
    }

    protected void refreshInstances() {
        for (MicroserviceVersions versions : this.versionsByName.values()) {
            versions.submitPull();
        }
    }
}

