/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.Subscribe;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstanceStatus;
import io.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import io.servicecomb.serviceregistry.consumer.AppManager;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import io.servicecomb.serviceregistry.task.event.PullMicroserviceVersionsInstancesEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceVersions.class);
    private AppManager appManager;
    private String appId;
    private String microserviceName;
    private List<MicroserviceInstance> instances;
    private Map<String, MicroserviceVersion> versions = new ConcurrentHashMap<String, MicroserviceVersion>();
    private Map<String, MicroserviceVersionRule> versionRules = new ConcurrentHashMap<String, MicroserviceVersionRule>();
    private final Object lock = new Object();
    private AtomicInteger pendingPullCount = new AtomicInteger();

    public MicroserviceVersions(AppManager appManager, String appId, String microserviceName) {
        this.appManager = appManager;
        this.appId = appId;
        this.microserviceName = microserviceName;
        LOGGER.info("create MicroserviceVersions, appId={}, microserviceName={}.", (Object)appId, (Object)microserviceName);
        appManager.getEventBus().register((Object)this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public Map<String, MicroserviceVersion> getVersions() {
        return this.versions;
    }

    public <T extends MicroserviceVersion> T getVersion(String serviceId) {
        return (T)this.versions.get(serviceId);
    }

    public void submitPull() {
        this.pendingPullCount.incrementAndGet();
        this.pullInstances();
    }

    public void pullInstances() {
        if (this.pendingPullCount.decrementAndGet() != 0) {
            return;
        }
        List<MicroserviceInstance> pulledInstances = RegistryUtils.findServiceInstance(this.appId, this.microserviceName, "0.0.0+");
        if (pulledInstances == null) {
            return;
        }
        this.setInstances(pulledInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstances(List<MicroserviceInstance> pulledInstances) {
        Object object = this.lock;
        synchronized (object) {
            this.instances = pulledInstances.stream().filter(instance -> MicroserviceInstanceStatus.UP.equals((Object)instance.getStatus())).collect(Collectors.toList());
            for (MicroserviceInstance instance2 : this.instances) {
                this.versions.computeIfAbsent(instance2.getServiceId(), microserviceId -> {
                    MicroserviceVersion microserviceVersion = this.appManager.getMicroserviceVersionFactory().create(this.microserviceName, (String)microserviceId);
                    for (MicroserviceVersionRule microserviceVersionRule : this.versionRules.values()) {
                        microserviceVersionRule.addMicroserviceVersion(microserviceVersion);
                    }
                    return microserviceVersion;
                });
            }
            for (MicroserviceVersionRule microserviceVersionRule : this.versionRules.values()) {
                microserviceVersionRule.setInstances(this.instances);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String versionRule) {
        MicroserviceVersionRule microserviceVersionRule = this.versionRules.get(versionRule);
        if (microserviceVersionRule == null) {
            Object object = this.lock;
            synchronized (object) {
                microserviceVersionRule = this.versionRules.get(versionRule);
                if (microserviceVersionRule == null) {
                    microserviceVersionRule = this.createAndInitMicroserviceVersionRule(versionRule);
                    this.versionRules.put(versionRule, microserviceVersionRule);
                }
            }
        }
        return microserviceVersionRule;
    }

    protected MicroserviceVersionRule createAndInitMicroserviceVersionRule(String strVersionRule) {
        LOGGER.info("create MicroserviceVersionRule, appId={}, microserviceName={}, versionRule={}.", new Object[]{this.appId, this.microserviceName, strVersionRule});
        MicroserviceVersionRule microserviceVersionRule = new MicroserviceVersionRule(this.appId, this.microserviceName, strVersionRule);
        for (MicroserviceVersion microserviceVersion : this.versions.values()) {
            microserviceVersionRule.addMicroserviceVersion(microserviceVersion);
        }
        microserviceVersionRule.setInstances(this.instances);
        return microserviceVersionRule;
    }

    @Subscribe
    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        if (!this.appId.equals(changedEvent.getKey().getAppId()) || !this.microserviceName.equals(changedEvent.getKey().getServiceName())) {
            return;
        }
        this.pendingPullCount.incrementAndGet();
        this.appManager.getEventBus().post((Object)new PullMicroserviceVersionsInstancesEvent(this, TimeUnit.SECONDS.toMillis(1L)));
    }
}

