/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.definition;

import com.netflix.config.ConcurrentCompositeConfiguration;
import io.servicecomb.config.ConfigUtil;
import io.servicecomb.config.archaius.sources.ConfigModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MicroserviceDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceDefinition.class);
    private Set<String> combinedFrom = new HashSet<String>();
    private List<ConfigModel> configModels;
    private Configuration configuration;
    private String microserviceName;
    private String applicationId;

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public static MicroserviceDefinition create(String appId, String microserviceName) {
        ConfigModel configModel = MicroserviceDefinition.createConfigModel(appId, microserviceName);
        return new MicroserviceDefinition(Arrays.asList(configModel));
    }

    public static ConfigModel createConfigModel(String appId, String microserviceName) {
        HashMap<String, String> descMap = new HashMap<String, String>();
        descMap.put("name", microserviceName);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("APPLICATION_ID", appId);
        config.put("service_description", descMap);
        ConfigModel configModel = new ConfigModel();
        configModel.setConfig(config);
        return configModel;
    }

    public MicroserviceDefinition(List<ConfigModel> configModels) {
        if (configModels == null) {
            configModels = Collections.emptyList();
        }
        this.configModels = configModels;
        this.configuration = ConfigUtil.createLocalConfig(configModels);
        this.microserviceName = this.configuration.getString("service_description.name", "defaultMicroservice");
        this.applicationId = this.configuration.getString("APPLICATION_ID", "defaultApplicationId");
        this.logConfigPath();
        this.checkMicroserviceName(this.microserviceName);
        this.initCombinedFrom(configModels);
    }

    public Set<String> getCombinedFrom() {
        return this.combinedFrom;
    }

    private void initCombinedFrom(List<ConfigModel> configModels) {
        for (ConfigModel model : configModels) {
            ConcurrentCompositeConfiguration conf = ConfigUtil.createLocalConfig(Arrays.asList(model));
            String name = conf.getString("service_description.name", "defaultMicroservice");
            if (StringUtils.isEmpty((Object)name)) continue;
            this.checkMicroserviceName(name);
            this.combinedFrom.add(name);
        }
        this.combinedFrom.remove(this.microserviceName);
    }

    private void checkMicroserviceName(String name) {
        if (StringUtils.isEmpty((Object)name) || name.contains("${")) {
            throw new IllegalArgumentException(String.format("MicroserviceName '%s' is invalid. you must configure '%s' or set the placeholder value.", name, "service_description.name"));
        }
    }

    public void logConfigPath() {
        ArrayList<String> pathList = new ArrayList<String>();
        for (ConfigModel configModel : this.configModels) {
            if (configModel.getUrl() == null) continue;
            pathList.add(configModel.getUrl().toString());
        }
        LOGGER.info("load microservice config, name={}, paths={}", (Object)this.microserviceName, pathList);
    }

    public List<ConfigModel> getConfigModels() {
        return this.configModels;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

