/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.discovery;

import io.servicecomb.foundation.common.cache.VersionedCache;
import io.servicecomb.foundation.common.exceptions.ServiceCombException;
import io.servicecomb.foundation.common.utils.SPIServiceUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.discovery.DiscoveryContext;
import io.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import io.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryTree.class);
    private DiscoveryTreeNode root;
    private final Object lock = new Object();
    private List<DiscoveryFilter> filters = new ArrayList<DiscoveryFilter>();

    public void loadFromSPI(Class<? extends DiscoveryFilter> cls) {
        this.filters.addAll(SPIServiceUtils.getSortedService(cls));
    }

    public void addFilter(DiscoveryFilter filter) {
        this.filters.add(filter);
    }

    public void sort() {
        this.filters.sort((f1, f2) -> Integer.compare(f1.getOrder(), f2.getOrder()));
        LOGGER.info("found DiscoveryFilter:");
        for (DiscoveryFilter filter : this.filters) {
            LOGGER.info("DiscoveryFilter {}.", (Object)filter.getClass().getName());
        }
    }

    protected boolean isExpired(VersionedCache existing, VersionedCache inputCache) {
        return existing == null || existing.isExpired(inputCache);
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, String appId, String microserviceName, String versionRule) {
        VersionedCache instanceVersionedCache = RegistryUtils.getServiceRegistry().getInstanceCacheManager().getOrCreateVersionedCache(appId, microserviceName, versionRule);
        return this.discovery(context, instanceVersionedCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryTreeNode discovery(DiscoveryContext context, VersionedCache inputCache) {
        DiscoveryTreeNode tmpRoot = this.root;
        if (this.isExpired(tmpRoot, inputCache)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isExpired(tmpRoot, inputCache)) {
                    tmpRoot = this.root = (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
                }
            }
        }
        if (tmpRoot.cacheVersion() > inputCache.cacheVersion()) {
            tmpRoot = (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
        }
        DiscoveryTreeNode parent = tmpRoot.children().computeIfAbsent(inputCache.name(), name -> new DiscoveryTreeNode().fromCache(inputCache));
        return this.doDiscovery(context, parent);
    }

    protected DiscoveryTreeNode doDiscovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        int idx = 0;
        while (idx < this.filters.size()) {
            DiscoveryTreeNode rerunNode;
            DiscoveryFilter filter = this.filters.get(idx);
            context.setCurrentNode(parent);
            DiscoveryTreeNode child = filter.discovery(context, parent);
            if (child == null) {
                throw new ServiceCombException(filter.getClass().getName() + " discovery return null.");
            }
            child.level(idx + 1);
            if (!filter.isGroupingFilter()) {
                child.name(parent.name());
            }
            if (child.isEmpty() && (rerunNode = context.popRerunFilter()) != null) {
                parent = rerunNode;
                idx = parent.level();
                continue;
            }
            parent = child;
            ++idx;
        }
        return parent;
    }
}

