/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.client.http.ServiceRegistryClientImpl;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import io.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import io.servicecomb.serviceregistry.registry.AbstractServiceRegistry;
import io.servicecomb.serviceregistry.task.event.PeriodicPullEvent;
import io.servicecomb.serviceregistry.task.event.PullMicroserviceVersionsInstancesEvent;
import io.servicecomb.serviceregistry.task.event.ShutdownEvent;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceRegistry.class);
    private ScheduledThreadPoolExecutor taskPool;

    public RemoteServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        super(eventBus, serviceRegistryConfig, microserviceDefinition);
    }

    @Override
    public void init() {
        super.init();
        this.taskPool = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                return new Thread(task, "Service Center Task");
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
                LOGGER.warn("Too many pending tasks, reject " + task.getClass().getName());
            }
        });
    }

    @Override
    protected ServiceRegistryClient createServiceRegistryClient() {
        return new ServiceRegistryClientImpl(this.ipPortManager);
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        LOGGER.info("service center task is shutdown.");
        this.taskPool.shutdownNow();
    }

    @Override
    public void run() {
        super.run();
        this.ipPortManager.initAutoDiscovery();
        this.taskPool.scheduleAtFixedRate(this.serviceCenterTask, this.serviceRegistryConfig.getHeartbeatInterval(), this.serviceRegistryConfig.getHeartbeatInterval(), TimeUnit.SECONDS);
        if (this.isNeedPull()) {
            this.taskPool.scheduleAtFixedRate(() -> this.eventBus.post((Object)new PeriodicPullEvent()), this.serviceRegistryConfig.getInstancePullInterval(), this.serviceRegistryConfig.getInstancePullInterval(), TimeUnit.SECONDS);
        }
    }

    private boolean isNeedPull() {
        return !this.serviceRegistryConfig.isWatch();
    }

    @Subscribe
    public void onPullMicroserviceVersionsInstancesEvent(PullMicroserviceVersionsInstancesEvent event) {
        this.taskPool.schedule(event.getMicroserviceVersions()::pullInstances, event.getMsDelay(), TimeUnit.MILLISECONDS);
    }

    ScheduledThreadPoolExecutor getTaskPool() {
        return this.taskPool;
    }
}

