/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.servicecomb.foundation.common.event.EventManager;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.task.AbstractTask;
import io.servicecomb.serviceregistry.task.HeartbeatResult;
import io.servicecomb.serviceregistry.task.MicroserviceWatchTask;
import io.servicecomb.serviceregistry.task.TaskStatus;
import io.servicecomb.serviceregistry.task.event.HeartbeatFailEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceHeartbeatTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceHeartbeatTask.class);
    private MicroserviceInstance microserviceInstance;
    private HeartbeatResult heartbeatResult;

    public MicroserviceInstanceHeartbeatTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.microserviceInstance = microservice.getIntance();
    }

    @Subscribe
    public void onMicroserviceWatchTask(MicroserviceWatchTask task) {
        if (task.taskStatus == TaskStatus.READY && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
        }
    }

    public HeartbeatResult getHeartbeatResult() {
        return this.heartbeatResult;
    }

    public boolean isNeedRegisterInstance() {
        return HeartbeatResult.INSTANCE_NOT_REGISTERED.equals((Object)this.heartbeatResult);
    }

    @Override
    public void doRun() {
        this.heartbeatResult = this.heartbeat();
    }

    private HeartbeatResult heartbeat() {
        HeartbeatResponse response = this.srClient.heartbeat(this.microserviceInstance.getServiceId(), this.microserviceInstance.getInstanceId());
        if (response == null) {
            LOGGER.error("Disconnected from service center and heartbeat failed for microservice instance={}/{}", (Object)this.microserviceInstance.getServiceId(), (Object)this.microserviceInstance.getInstanceId());
            EventManager.post((Object)new HeartbeatFailEvent());
            return HeartbeatResult.DISCONNECTED;
        }
        if (!response.isOk()) {
            LOGGER.error("Update heartbeat to service center failed, microservice instance={}/{} does not exist", (Object)this.microserviceInstance.getServiceId(), (Object)this.microserviceInstance.getInstanceId());
            EventManager.post((Object)new HeartbeatFailEvent());
            return HeartbeatResult.INSTANCE_NOT_REGISTERED;
        }
        return HeartbeatResult.SUCCESS;
    }
}

