/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import io.servicecomb.serviceregistry.task.AbstractRegisterTask;
import io.servicecomb.serviceregistry.task.MicroserviceRegisterTask;
import io.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MicroserviceInstanceRegisterTask
extends AbstractRegisterTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceRegisterTask.class);
    private ServiceRegistryConfig serviceRegistryConfig;
    private MicroserviceInstance microserviceInstance;

    public MicroserviceInstanceRegisterTask(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceInstance = microservice.getIntance();
    }

    @Subscribe
    public void onMicroserviceRegisterTask(MicroserviceRegisterTask task) {
        if (task.taskStatus == TaskStatus.FINISHED && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        } else {
            this.taskStatus = TaskStatus.INIT;
        }
    }

    @Override
    protected boolean doRegister() {
        LOGGER.info("running microservice instance register task.");
        String hostName = "";
        hostName = this.serviceRegistryConfig.isPreferIpAddress() ? RegistryUtils.getPublishAddress() : RegistryUtils.getPublishHostName();
        this.microserviceInstance.setHostName(hostName);
        this.microserviceInstance.getHealthCheck().setInterval(this.serviceRegistryConfig.getHeartbeatInterval());
        this.microserviceInstance.getHealthCheck().setTimes(this.serviceRegistryConfig.getResendHeartBeatTimes());
        String instanceId = this.srClient.registerMicroserviceInstance(this.microserviceInstance);
        if (StringUtils.isEmpty((Object)instanceId)) {
            LOGGER.error("Register microservice instance failed. microserviceId={}", (Object)this.microserviceInstance.getServiceId());
            return false;
        }
        this.microserviceInstance.setInstanceId(instanceId);
        LOGGER.info("Register microservice instance success. microserviceId={} instanceId={} endpoints={} lease {}s", new Object[]{this.microserviceInstance.getServiceId(), instanceId, this.microserviceInstance.getEndpoints(), this.microserviceInstance.getHealthCheck().getTTL()});
        return true;
    }
}

