/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;

public final class SchemaBroadcastBackendHandler
extends AbstractBackendHandler {
    private final int sequenceId;
    private final String sql;
    private final BackendConnection backendConnection;
    private final DatabaseType databaseType;
    private final BackendHandlerFactory backendHandlerFactory;

    @Override
    protected CommandResponsePackets execute0() {
        LinkedList<DatabasePacket> packets = new LinkedList<DatabasePacket>();
        String originSchemaName = this.backendConnection.getSchemaName();
        for (String each : GlobalRegistry.getInstance().getSchemaNames()) {
            this.backendConnection.setCurrentSchema(each);
            CommandResponsePackets responsePackets = this.backendHandlerFactory.newTextProtocolInstance(this.sequenceId, this.sql, this.backendConnection, this.databaseType).execute();
            packets.addAll(responsePackets.getPackets());
        }
        this.backendConnection.setCurrentSchema(originSchemaName);
        return this.merge(packets);
    }

    private CommandResponsePackets merge(Collection<DatabasePacket> packets) {
        int affectedRows = 0;
        long lastInsertId = 0L;
        for (DatabasePacket each : packets) {
            if (each instanceof ErrPacket) {
                return new CommandResponsePackets(each);
            }
            if (!(each instanceof OKPacket)) continue;
            affectedRows = (int)((long)affectedRows + ((OKPacket)each).getAffectedRows());
            if (((OKPacket)each).getLastInsertId() <= lastInsertId) continue;
            lastInsertId = ((OKPacket)each).getLastInsertId();
        }
        return new CommandResponsePackets(new OKPacket(1, affectedRows, lastInsertId));
    }

    @ConstructorProperties(value={"sequenceId", "sql", "backendConnection", "databaseType", "backendHandlerFactory"})
    public SchemaBroadcastBackendHandler(int sequenceId, String sql, BackendConnection backendConnection, DatabaseType databaseType, BackendHandlerFactory backendHandlerFactory) {
        this.sequenceId = sequenceId;
        this.sql = sql;
        this.backendConnection = backendConnection;
        this.databaseType = databaseType;
        this.backendHandlerFactory = backendHandlerFactory;
    }
}

