/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.netty.client.response.ResponseHandlerFactory;
import io.shardingsphere.shardingproxy.transport.common.codec.PacketCodecFactory;
import java.beans.ConstructorProperties;

public final class BackendNettyClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final String dataSourceName;
    private final String schemaName;

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{PacketCodecFactory.newInstance(DatabaseType.MySQL)});
        pipeline.addLast(new ChannelHandler[]{ResponseHandlerFactory.newInstance(DatabaseType.MySQL, this.dataSourceName, this.schemaName)});
    }

    @ConstructorProperties(value={"dataSourceName", "schemaName"})
    public BackendNettyClientChannelInitializer(String dataSourceName, String schemaName) {
        this.dataSourceName = dataSourceName;
        this.schemaName = schemaName;
    }
}

