/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client;

import io.netty.channel.EventLoopGroup;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClient;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import java.util.HashMap;
import java.util.Map;

public final class BackendNettyClientManager {
    private static final BackendNettyClientManager INSTANCE = new BackendNettyClientManager();
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private final Map<String, BackendNettyClient> clientMap = new HashMap<String, BackendNettyClient>();

    public static BackendNettyClientManager getInstance() {
        return INSTANCE;
    }

    public BackendNettyClient getBackendNettyClient(String schema) {
        return this.clientMap.get(schema);
    }

    public void start(EventLoopGroup eventLoopGroup) throws InterruptedException {
        for (String each : GLOBAL_REGISTRY.getSchemaNames()) {
            BackendNettyClient backendNettyClient = new BackendNettyClient(GLOBAL_REGISTRY.getLogicSchema(each), eventLoopGroup);
            this.clientMap.put(each, backendNettyClient);
            backendNettyClient.start();
        }
    }

    public void stop() {
        for (BackendNettyClient backendNettyClient : this.clientMap.values()) {
            backendNettyClient.stop();
        }
    }

    private BackendNettyClientManager() {
    }
}

